/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test.lookup.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.assertj.core.api.AbstractAssert;

public class LookupCacheAssert
extends AbstractAssert<LookupCacheAssert, LookupCache> {
    public static LookupCacheAssert assertThat(LookupCache actual) {
        return new LookupCacheAssert(actual);
    }

    public LookupCacheAssert(LookupCache actual) {
        super((Object)actual, LookupCacheAssert.class);
    }

    public LookupCacheAssert hasSize(int size) {
        if (((LookupCache)this.actual).size() != (long)size) {
            this.failWithMessage("Expected lookup cache to have %d entries but was %d", new Object[]{size, ((LookupCache)this.actual).size()});
        }
        return this;
    }

    public LookupCacheAssert containsKey(RowData keyRow) {
        if (((LookupCache)this.actual).getIfPresent(keyRow) == null) {
            this.failWithMessage("Expected lookup cache to contain key '%s' but not found", new Object[]{keyRow});
        }
        return this;
    }

    public LookupCacheAssert containsKey(Object ... keyFields) {
        return this.containsKey((RowData)GenericRowData.of((Object[])keyFields));
    }

    public LookupCacheAssert doesNotContainKey(RowData keyRow) {
        if (((LookupCache)this.actual).getIfPresent(keyRow) != null) {
            this.failWithMessage("Expected lookup cache not to contain key '%s' but found", new Object[0]);
        }
        return this;
    }

    public LookupCacheAssert doesNotContainKey(Object ... keyFields) {
        return this.doesNotContainKey((RowData)GenericRowData.of((Object[])keyFields));
    }

    public LookupCacheAssert containsExactlyEntriesOf(Map<RowData, Collection<RowData>> entries) {
        this.hasSize(entries.size());
        for (Map.Entry<RowData, Collection<RowData>> entry : entries.entrySet()) {
            this.contains(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public LookupCacheAssert contains(RowData keyRow, Collection<RowData> valueRows) {
        this.containsKey(keyRow);
        Collection cachedValueRows = ((LookupCache)this.actual).getIfPresent(keyRow);
        assert (cachedValueRows != null);
        if (!cachedValueRows.equals(valueRows)) {
            this.failWithActualExpectedAndMessage(((LookupCache)this.actual).getIfPresent(keyRow), valueRows, "Lookup cache entry with key '%s' is not as expected", new Object[]{keyRow});
        }
        return this;
    }

    public LookupCacheAssert contains(RowData keyRow, RowData ... valueRows) {
        return this.contains(keyRow, Arrays.asList(valueRows));
    }
}

