/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.time.Duration;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.utils.IntervalFreshnessUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class IntervalFreshnessUtilsTest {
    @Test
    void testIllegalIntervalFreshness() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IntervalFreshnessUtils.validateIntervalFreshness((IntervalFreshness)IntervalFreshness.ofMinute((String)"2efedd"))).isInstanceOf(ValidationException.class)).hasMessageContaining("The interval freshness value '2efedd' is an illegal integer type value.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IntervalFreshnessUtils.validateIntervalFreshness((IntervalFreshness)IntervalFreshness.ofMinute((String)"2.5"))).isInstanceOf(ValidationException.class)).hasMessageContaining("The freshness interval currently only supports integer type values.");
    }

    @Test
    void testConvertFreshnessToDuration() {
        Duration actualSecond = IntervalFreshnessUtils.convertFreshnessToDuration((IntervalFreshness)IntervalFreshness.ofSecond((String)"20"));
        Assertions.assertThat((Duration)actualSecond).isEqualTo((Object)Duration.ofSeconds(20L));
        Duration actualMinute = IntervalFreshnessUtils.convertFreshnessToDuration((IntervalFreshness)IntervalFreshness.ofMinute((String)"3"));
        Assertions.assertThat((Duration)actualMinute).isEqualTo((Object)Duration.ofMinutes(3L));
        Duration actualHour = IntervalFreshnessUtils.convertFreshnessToDuration((IntervalFreshness)IntervalFreshness.ofHour((String)"3"));
        Assertions.assertThat((Duration)actualHour).isEqualTo((Object)Duration.ofHours(3L));
        Duration actualDay = IntervalFreshnessUtils.convertFreshnessToDuration((IntervalFreshness)IntervalFreshness.ofDay((String)"3"));
        Assertions.assertThat((Duration)actualDay).isEqualTo((Object)Duration.ofDays(3L));
    }

    @Test
    void testConvertSecondFreshnessToCronExpression() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofSecond((String)"90"))).isInstanceOf(ValidationException.class)).hasMessageContaining("In full refresh mode, freshness must be less than 60 when the time unit is SECOND.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofSecond((String)"32"))).isInstanceOf(ValidationException.class)).hasMessageContaining("In full refresh mode, only freshness that are factors of 60 are currently supported when the time unit is SECOND.");
        String actual1 = IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofSecond((String)"30"));
        Assertions.assertThat((String)actual1).isEqualTo("0/30 * * * * ? *");
        String actual2 = IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofSecond((String)"5"));
        Assertions.assertThat((String)actual2).isEqualTo("0/5 * * * * ? *");
    }

    @Test
    void testConvertMinuteFreshnessToCronExpression() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofMinute((String)"90"))).isInstanceOf(ValidationException.class)).hasMessageContaining("In full refresh mode, freshness must be less than 60 when the time unit is MINUTE.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofMinute((String)"32"))).isInstanceOf(ValidationException.class)).hasMessageContaining("In full refresh mode, only freshness that are factors of 60 are currently supported when the time unit is MINUTE.");
        String actual1 = IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofMinute((String)"30"));
        Assertions.assertThat((String)actual1).isEqualTo("0 0/30 * * * ? *");
        String actual2 = IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofMinute((String)"5"));
        Assertions.assertThat((String)actual2).isEqualTo("0 0/5 * * * ? *");
        String actual3 = IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofMinute((String)"1"));
        Assertions.assertThat((String)actual3).isEqualTo("0 0/1 * * * ? *");
    }

    @Test
    void testConvertHourFreshnessToCronExpression() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofHour((String)"24"))).isInstanceOf(ValidationException.class)).hasMessageContaining("In full refresh mode, freshness must be less than 24 when the time unit is HOUR.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofHour((String)"14"))).isInstanceOf(ValidationException.class)).hasMessageContaining("In full refresh mode, only freshness that are factors of 24 are currently supported when the time unit is HOUR.");
        String actual1 = IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofHour((String)"12"));
        Assertions.assertThat((String)actual1).isEqualTo("0 0 0/12 * * ? *");
        String actual2 = IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofHour((String)"4"));
        Assertions.assertThat((String)actual2).isEqualTo("0 0 0/4 * * ? *");
        String actual3 = IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofHour((String)"1"));
        Assertions.assertThat((String)actual3).isEqualTo("0 0 0/1 * * ? *");
    }

    @Test
    void testConvertDayFreshnessToCronExpression() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofDay((String)"2"))).isInstanceOf(ValidationException.class)).hasMessageContaining("In full refresh mode, freshness must be 1 when the time unit is DAY.");
        String actual1 = IntervalFreshnessUtils.convertFreshnessToCron((IntervalFreshness)IntervalFreshness.ofDay((String)"1"));
        Assertions.assertThat((String)actual1).isEqualTo("0 0 0 * * ? *");
    }
}

