/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.List;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ObjectIdentifierTest {
    ObjectIdentifierTest() {
    }

    @Test
    void testAnonymousIdentifier() {
        String objectName = "my_anonymous_table";
        ObjectIdentifier objectIdentifier = ObjectIdentifier.ofAnonymous((String)objectName);
        Assertions.assertThat((String)objectIdentifier.getCatalogName()).isEqualTo("<UNKNOWN>");
        Assertions.assertThat((String)objectIdentifier.getDatabaseName()).isEqualTo("<UNKNOWN>");
        Assertions.assertThat((List)objectIdentifier.toList()).containsExactly((Object[])new String[]{objectName});
        Assertions.assertThat((String)objectIdentifier.asSummaryString()).isEqualTo(objectIdentifier.toString()).isEqualTo(objectName);
        Assertions.assertThatThrownBy(() -> ((ObjectIdentifier)objectIdentifier).asSerializableString()).isInstanceOf(TableException.class);
        Assertions.assertThatThrownBy(() -> ((ObjectIdentifier)objectIdentifier).toObjectPath()).isInstanceOf(TableException.class);
    }
}

