/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.utils;

import java.util.Optional;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.VoidSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.UnresolvedDataType;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.types.utils.TypeInfoDataTypeConverter;
import org.assertj.core.api.Assertions;

public class DataTypeFactoryMock
implements DataTypeFactory {
    public Optional<DataType> dataType = Optional.empty();
    public Optional<LogicalType> logicalType = Optional.empty();
    public Optional<Class<?>> expectedClass = Optional.empty();

    public DataType createDataType(AbstractDataType<?> abstractDataType) {
        if (abstractDataType instanceof DataType) {
            return (DataType)abstractDataType;
        }
        if (abstractDataType instanceof UnresolvedDataType) {
            return ((UnresolvedDataType)abstractDataType).toDataType((DataTypeFactory)this);
        }
        throw new IllegalStateException();
    }

    public DataType createDataType(String typeString) {
        return TypeConversions.fromLogicalToDataType((LogicalType)LogicalTypeParser.parse((String)typeString, (ClassLoader)Thread.currentThread().getContextClassLoader()));
    }

    public DataType createDataType(UnresolvedIdentifier identifier) {
        return this.dataType.orElseThrow(() -> new ValidationException("No type found."));
    }

    public <T> DataType createDataType(Class<T> clazz) {
        this.expectedClass.ifPresent(expected -> Assertions.assertThat((Class)expected).isEqualTo((Object)clazz));
        return DataTypeExtractor.extractFromType((DataTypeFactory)this, clazz);
    }

    public <T> DataType createDataType(TypeInformation<T> typeInfo) {
        return TypeInfoDataTypeConverter.toDataType((DataTypeFactory)this, typeInfo);
    }

    public <T> DataType createRawDataType(Class<T> clazz) {
        this.expectedClass.ifPresent(expected -> Assertions.assertThat((Class)expected).isEqualTo((Object)clazz));
        return this.dataType.orElseThrow(IllegalStateException::new);
    }

    public <T> DataType createRawDataType(TypeInformation<T> typeInfo) {
        return this.dataType.orElseThrow(IllegalStateException::new);
    }

    public LogicalType createLogicalType(String typeString) {
        return this.logicalType.orElseThrow(() -> new ValidationException("No type found."));
    }

    public LogicalType createLogicalType(UnresolvedIdentifier identifier) {
        return this.logicalType.orElseThrow(() -> new ValidationException("No type found."));
    }

    public static DataType dummyRaw(Class<?> clazz) {
        return DataTypes.RAW(clazz, DataTypeFactoryMock.dummySerializer());
    }

    public static <T> TypeSerializer<T> dummySerializer() {
        return VoidSerializer.INSTANCE;
    }
}

