/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.legacy.sources.ProjectableTableSource;
import org.apache.flink.table.legacy.sources.TableSource;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;

abstract class TableSourceTestBase {
    TableSourceTestBase() {
    }

    protected abstract TableSource<?> createTableSource(TableSchema var1);

    @Test
    void testEmptyProjection() {
        TableSource<?> source = this.createTableSource(TableSchema.builder().field("f0", DataTypes.INT()).build());
        Assumptions.assumeThat(source).isInstanceOf(ProjectableTableSource.class);
        ProjectableTableSource projectableTableSource = (ProjectableTableSource)source;
        TableSource newTableSource = projectableTableSource.projectFields(new int[0]);
        Assertions.assertThat((String)newTableSource.explainSource()).isNotEqualTo((Object)source.explainSource());
    }

    @Test
    void testProjectionReturnsDifferentSource() {
        TableSource<?> source = this.createTableSource(TableSchema.builder().field("f0", DataTypes.INT()).field("f1", DataTypes.STRING()).field("f2", DataTypes.BIGINT()).build());
        Assumptions.assumeThat(source).isInstanceOf(ProjectableTableSource.class);
        ProjectableTableSource projectableTableSource = (ProjectableTableSource)source;
        TableSource newTableSource = projectableTableSource.projectFields(new int[]{0, 2});
        Assertions.assertThat((String)newTableSource.explainSource()).isNotEqualTo((Object)source.explainSource());
        Assertions.assertThat((Object)newTableSource.getTableSchema()).isEqualTo((Object)source.getTableSchema());
    }
}

