/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.ml;

import org.apache.flink.table.ml.TaskType;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TaskTypeTest {
    @Test
    public void testEnumValues() {
        Assertions.assertThat((Object[])TaskType.values()).hasSize(5);
        Assertions.assertThat((Comparable)TaskType.valueOf((String)"REGRESSION")).isEqualTo((Object)TaskType.REGRESSION);
        Assertions.assertThat((Comparable)TaskType.valueOf((String)"CLUSTERING")).isEqualTo((Object)TaskType.CLUSTERING);
        Assertions.assertThat((Comparable)TaskType.valueOf((String)"CLASSIFICATION")).isEqualTo((Object)TaskType.CLASSIFICATION);
        Assertions.assertThat((Comparable)TaskType.valueOf((String)"EMBEDDING")).isEqualTo((Object)TaskType.EMBEDDING);
        Assertions.assertThat((Comparable)TaskType.valueOf((String)"TEXT_GENERATION")).isEqualTo((Object)TaskType.TEXT_GENERATION);
    }

    @Test
    public void testGetName() {
        Assertions.assertThat((String)TaskType.REGRESSION.getName()).isEqualTo("regression");
        Assertions.assertThat((String)TaskType.CLUSTERING.getName()).isEqualTo("clustering");
        Assertions.assertThat((String)TaskType.CLASSIFICATION.getName()).isEqualTo("classification");
        Assertions.assertThat((String)TaskType.EMBEDDING.getName()).isEqualTo("embedding");
        Assertions.assertThat((String)TaskType.TEXT_GENERATION.getName()).isEqualTo("text_generation");
    }

    @Test
    public void testFromName() {
        Assertions.assertThat((Comparable)TaskType.fromName((String)"regression")).isEqualTo((Object)TaskType.REGRESSION);
        Assertions.assertThat((Comparable)TaskType.fromName((String)"clustering")).isEqualTo((Object)TaskType.CLUSTERING);
        Assertions.assertThat((Comparable)TaskType.fromName((String)"classification")).isEqualTo((Object)TaskType.CLASSIFICATION);
        Assertions.assertThat((Comparable)TaskType.fromName((String)"embedding")).isEqualTo((Object)TaskType.EMBEDDING);
        Assertions.assertThat((Comparable)TaskType.fromName((String)"text_generation")).isEqualTo((Object)TaskType.TEXT_GENERATION);
    }

    @Test
    public void testFromNameWithInvalidName() {
        Assertions.assertThatThrownBy(() -> TaskType.fromName((String)"invalid_task_type")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void testIsValidTaskType() {
        Assertions.assertThat((boolean)TaskType.isValidTaskType((String)"regression")).isTrue();
        Assertions.assertThat((boolean)TaskType.isValidTaskType((String)"clustering")).isTrue();
        Assertions.assertThat((boolean)TaskType.isValidTaskType((String)"classification")).isTrue();
        Assertions.assertThat((boolean)TaskType.isValidTaskType((String)"embedding")).isTrue();
        Assertions.assertThat((boolean)TaskType.isValidTaskType((String)"text_generation")).isTrue();
        Assertions.assertThat((boolean)TaskType.isValidTaskType((String)"invalid_task_type")).isFalse();
        Assertions.assertThat((boolean)TaskType.isValidTaskType((String)"")).isFalse();
        Assertions.assertThat((boolean)TaskType.isValidTaskType(null)).isFalse();
    }
}

