/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.ModelProviderFactory;
import org.apache.flink.table.ml.ModelProvider;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;

public final class FactoryMocks {
    public static final ResolvedSchema SCHEMA = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)DataTypes.STRING()), Column.physical((String)"b", (DataType)DataTypes.INT()), Column.physical((String)"c", (DataType)DataTypes.BOOLEAN())});
    public static final DataType PHYSICAL_DATA_TYPE = SCHEMA.toPhysicalRowDataType();
    public static final RowType PHYSICAL_TYPE = (RowType)PHYSICAL_DATA_TYPE.getLogicalType();
    public static final ResolvedSchema OUTPUT_SCHEMA = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"output", (DataType)DataTypes.STRING())});
    public static final ObjectIdentifier IDENTIFIER = ObjectIdentifier.of((String)"default", (String)"default", (String)"t1");
    public static final ObjectIdentifier MODEL_IDENTIFIER = ObjectIdentifier.of((String)"default", (String)"default", (String)"m1");

    public static ModelProvider createModelProvider(ResolvedSchema inputSchema, ResolvedSchema outputSchema, Map<String, String> options) {
        return FactoryUtil.createModelProvider(null, (ObjectIdentifier)MODEL_IDENTIFIER, (ResolvedCatalogModel)ResolvedCatalogModel.of((CatalogModel)CatalogModel.of((Schema)Schema.newBuilder().fromResolvedSchema(inputSchema).build(), (Schema)Schema.newBuilder().fromResolvedSchema(outputSchema).build(), options, (String)"mock model"), (ResolvedSchema)inputSchema, (ResolvedSchema)outputSchema), (ReadableConfig)new Configuration(), (ClassLoader)FactoryMocks.class.getClassLoader(), (boolean)false);
    }

    public static DynamicTableSource createTableSource(ResolvedSchema schema, Map<String, String> options) {
        return FactoryMocks.createTableSource(schema, options, (ReadableConfig)new Configuration());
    }

    public static DynamicTableSource createTableSource(ResolvedSchema schema, Map<String, String> options, ReadableConfig readableConfig) {
        return FactoryUtil.createDynamicTableSource(null, (ObjectIdentifier)IDENTIFIER, (ResolvedCatalogTable)new ResolvedCatalogTable(CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(schema).build()).comment("mock source").options(options).build(), schema), Collections.emptyMap(), (ReadableConfig)readableConfig, (ClassLoader)FactoryMocks.class.getClassLoader(), (boolean)false);
    }

    public static DynamicTableSink createTableSink(ResolvedSchema schema, Map<String, String> options) {
        return FactoryMocks.createTableSink(schema, Collections.emptyList(), options);
    }

    public static DynamicTableSink createTableSink(ResolvedSchema schema, List<String> partitionKeys, Map<String, String> options) {
        return FactoryUtil.createDynamicTableSink(null, (ObjectIdentifier)IDENTIFIER, (ResolvedCatalogTable)new ResolvedCatalogTable(CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(schema).build()).comment("mock source").partitionKeys(partitionKeys).options(options).build(), schema), Collections.emptyMap(), (ReadableConfig)new Configuration(), (ClassLoader)FactoryMocks.class.getClassLoader(), (boolean)false);
    }

    public static ModelProviderFactory.Context createModelContext(ResolvedSchema schema, ResolvedSchema outputSchema, Map<String, String> options) {
        return new FactoryUtil.DefaultModelProviderContext(MODEL_IDENTIFIER, ResolvedCatalogModel.of((CatalogModel)CatalogModel.of((Schema)Schema.newBuilder().fromResolvedSchema(schema).build(), (Schema)Schema.newBuilder().fromResolvedSchema(outputSchema).build(), options, (String)"mock model"), (ResolvedSchema)schema, (ResolvedSchema)outputSchema), (ReadableConfig)new Configuration(), FactoryMocks.class.getClassLoader(), false);
    }

    public static DynamicTableFactory.Context createTableContext(ResolvedSchema schema, Map<String, String> options) {
        return FactoryMocks.createTableContext(schema, options, Collections.emptyMap());
    }

    public static DynamicTableFactory.Context createTableContext(ResolvedSchema schema, Map<String, String> options, Map<String, String> enrichmentOptions) {
        return new FactoryUtil.DefaultDynamicTableContext(IDENTIFIER, new ResolvedCatalogTable(CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(schema).build()).comment("mock context").options(options).build(), schema), enrichmentOptions, (ReadableConfig)new Configuration(), FactoryMocks.class.getClassLoader(), false);
    }

    private FactoryMocks() {
    }
}

