/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.factories.FactoryUtil;

public class TableOptionsBuilder {
    private final Map<String, String> options = new HashMap<String, String>();
    private final String connector;
    private final String format;

    public TableOptionsBuilder(String connector, String format) {
        this.connector = connector;
        this.format = format;
    }

    public TableOptionsBuilder withTableOption(ConfigOption<?> option, String value) {
        return this.withTableOption(option.key(), value);
    }

    public TableOptionsBuilder withFormatOption(ConfigOption<?> option, String value) {
        return this.withFormatOption(this.format + "." + option.key(), value);
    }

    public TableOptionsBuilder withTableOption(String key, String value) {
        this.options.put(key, value);
        return this;
    }

    public TableOptionsBuilder withFormatOption(String key, String value) {
        this.options.put(key, value);
        return this;
    }

    public Map<String, String> build() {
        this.withTableOption(FactoryUtil.CONNECTOR, this.connector);
        this.withTableOption(FactoryUtil.FORMAT, this.format);
        return this.options;
    }
}

