/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.CatalogPropertiesUtil;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.DefaultIndex;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogMaterializedTable;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.expressions.DefaultSqlFactory;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.types.DataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class CatalogPropertiesUtilTest {
    CatalogPropertiesUtilTest() {
    }

    @Test
    void testCatalogModelSerde() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("endpoint", "someendpoint");
        options.put("api_key", "fake_key");
        CatalogModel catalogModel = CatalogModel.of((Schema)Schema.newBuilder().column("f1", DataTypes.INT().getLogicalType().asSerializableString()).column("f2", DataTypes.STRING().getLogicalType().asSerializableString()).build(), (Schema)Schema.newBuilder().column("label", DataTypes.STRING().getLogicalType().asSerializableString()).build(), options, (String)"some comment");
        Column.PhysicalColumn f1 = Column.physical((String)"f1", (DataType)DataTypes.INT());
        Column.PhysicalColumn f2 = Column.physical((String)"f2", (DataType)DataTypes.STRING());
        Column.PhysicalColumn label = Column.physical((String)"label", (DataType)DataTypes.STRING());
        ResolvedSchema inputSchema = ResolvedSchema.of((Column[])new Column[]{f1, f2});
        ResolvedSchema outputSchema = ResolvedSchema.of((Column[])new Column[]{label});
        ResolvedCatalogModel testModel = ResolvedCatalogModel.of((CatalogModel)catalogModel, (ResolvedSchema)inputSchema, (ResolvedSchema)outputSchema);
        Map serializedMap = CatalogPropertiesUtil.serializeResolvedCatalogModel((ResolvedCatalogModel)testModel, (SqlFactory)DefaultSqlFactory.INSTANCE);
        CatalogModel deserializedModel = CatalogPropertiesUtil.deserializeCatalogModel((Map)serializedMap);
        Assertions.assertThat((String)deserializedModel.getInputSchema().toString()).isEqualTo(catalogModel.getInputSchema().toString());
        Assertions.assertThat((String)deserializedModel.getOutputSchema().toString()).isEqualTo(catalogModel.getOutputSchema().toString());
        Assertions.assertThat((Map)deserializedModel.getOptions()).isEqualTo((Object)catalogModel.getOptions());
        Assertions.assertThat((String)deserializedModel.getComment()).isEqualTo(catalogModel.getComment());
    }

    @ParameterizedTest
    @MethodSource(value={"resolvedCatalogBaseTables"})
    void testCatalogTableSerde(ResolvedCatalogBaseTable testTable) {
        CatalogTable deserializedTable;
        if (testTable instanceof ResolvedCatalogTable) {
            Map serializedMap = CatalogPropertiesUtil.serializeCatalogTable((ResolvedCatalogTable)((ResolvedCatalogTable)testTable), (SqlFactory)DefaultSqlFactory.INSTANCE);
            deserializedTable = CatalogPropertiesUtil.deserializeCatalogTable((Map)serializedMap);
        } else {
            Map serializedMap = CatalogPropertiesUtil.serializeCatalogMaterializedTable((ResolvedCatalogMaterializedTable)((ResolvedCatalogMaterializedTable)testTable), (SqlFactory)DefaultSqlFactory.INSTANCE);
            deserializedTable = CatalogPropertiesUtil.deserializeCatalogMaterializedTable((Map)serializedMap);
        }
        Assertions.assertThat((String)deserializedTable.getUnresolvedSchema().toString()).isEqualTo(testTable.getOrigin().getUnresolvedSchema().toString());
        Assertions.assertThat((Object)testTable.getOrigin()).hasToString(deserializedTable.toString());
    }

    private static Stream<ResolvedCatalogBaseTable<?>> resolvedCatalogBaseTables() {
        Schema schema = Schema.newBuilder().column("f1", DataTypes.INT().getLogicalType().asSerializableString()).column("f2", DataTypes.STRING().getLogicalType().asSerializableString()).primaryKey(new String[]{"f1"}).indexNamed("f1", Collections.singletonList("f1")).build();
        TableDistribution hashDist = TableDistribution.of((TableDistribution.Kind)TableDistribution.Kind.HASH, (Integer)2, List.of("f2"));
        TableDistribution rangeDist = TableDistribution.of((TableDistribution.Kind)TableDistribution.Kind.RANGE, (Integer)2, List.of("f1"));
        TableDistribution unknownDist = TableDistribution.of((TableDistribution.Kind)TableDistribution.Kind.UNKNOWN, (Integer)2, List.of("f1", "f2"));
        Column.PhysicalColumn f1 = Column.physical((String)"f1", (DataType)DataTypes.INT());
        Column.PhysicalColumn f2 = Column.physical((String)"f2", (DataType)DataTypes.STRING());
        List<Column> columns = Arrays.asList(f1, f2);
        UniqueConstraint primaryKey = UniqueConstraint.primaryKey((String)"PK_f1", Collections.singletonList("f1"));
        List<DefaultIndex> indexes = Collections.singletonList(DefaultIndex.newIndex((String)"f1", Collections.singletonList("f1")));
        ResolvedSchema resolvedSchema = new ResolvedSchema(columns, Collections.emptyList(), primaryKey, indexes);
        return Stream.of(new ResolvedCatalogTable(CatalogTable.newBuilder().schema(schema).comment("some comment").distribution(hashDist).build(), resolvedSchema), new ResolvedCatalogTable(CatalogTable.newBuilder().schema(schema).comment("some comment").distribution(rangeDist).build(), resolvedSchema), new ResolvedCatalogMaterializedTable(CatalogMaterializedTable.newBuilder().schema(schema).comment("some comment").distribution(unknownDist).definitionQuery("SELECT 1, 'two'").freshness(IntervalFreshness.ofHour((String)"123")).logicalRefreshMode(CatalogMaterializedTable.LogicalRefreshMode.CONTINUOUS).refreshMode(CatalogMaterializedTable.RefreshMode.CONTINUOUS).refreshStatus(CatalogMaterializedTable.RefreshStatus.ACTIVATED).refreshHandlerDescription("description").build(), resolvedSchema));
    }
}

