/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async;

import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.functions.async.AsyncRetryStrategy;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.async.AsyncWaitOperator;
import org.apache.flink.streaming.api.operators.legacy.YieldingOperatorFactory;
import org.apache.flink.streaming.util.retryable.AsyncRetryStrategies;

public class AsyncWaitOperatorFactory<IN, OUT>
extends AbstractStreamOperatorFactory<OUT>
implements OneInputStreamOperatorFactory<IN, OUT>,
YieldingOperatorFactory<OUT> {
    private final AsyncFunction<IN, OUT> asyncFunction;
    private final long timeout;
    private final int capacity;
    private final AsyncDataStream.OutputMode outputMode;
    private final AsyncRetryStrategy<OUT> asyncRetryStrategy;

    public AsyncWaitOperatorFactory(AsyncFunction<IN, OUT> asyncFunction, long timeout, int capacity, AsyncDataStream.OutputMode outputMode) {
        this(asyncFunction, timeout, capacity, outputMode, AsyncRetryStrategies.NO_RETRY_STRATEGY);
    }

    public AsyncWaitOperatorFactory(AsyncFunction<IN, OUT> asyncFunction, long timeout, int capacity, AsyncDataStream.OutputMode outputMode, AsyncRetryStrategy<OUT> asyncRetryStrategy) {
        this.asyncFunction = asyncFunction;
        this.timeout = timeout;
        this.capacity = capacity;
        this.outputMode = outputMode;
        this.chainingStrategy = ChainingStrategy.ALWAYS;
        this.asyncRetryStrategy = asyncRetryStrategy;
    }

    public <T extends StreamOperator<OUT>> T createStreamOperator(StreamOperatorParameters<OUT> parameters) {
        AsyncWaitOperator<IN, OUT> asyncWaitOperator = new AsyncWaitOperator<IN, OUT>(parameters, this.asyncFunction, this.timeout, this.capacity, this.outputMode, this.asyncRetryStrategy, this.processingTimeService, this.getMailboxExecutor());
        return (T)((Object)asyncWaitOperator);
    }

    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return AsyncWaitOperator.class;
    }
}

