/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.sstmerge;

import java.util.List;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.CompactionJobInfo;
import org.rocksdb.CompactionOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Compactor {
    private static final Logger LOG = LoggerFactory.getLogger(Compactor.class);
    private static final int OUTPUT_PATH_ID = 0;
    private final CompactionTarget db;
    private final long targetOutputFileSize;

    public Compactor(RocksDB db, long targetOutputFileSize) {
        this((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((RocksDB)db).compactFiles(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5), targetOutputFileSize);
    }

    public Compactor(CompactionTarget target, long targetOutputFileSize) {
        this.db = target;
        this.targetOutputFileSize = targetOutputFileSize;
    }

    void compact(ColumnFamilyHandle cfName, int level, List<String> files) throws RocksDBException {
        int outputLevel = Math.min(level + 1, cfName.getDescriptor().getOptions().numLevels() - 1);
        LOG.debug("Manually compacting {} files from level {} to {}: {}", new Object[]{files.size(), level, outputLevel, files});
        try (CompactionOptions options = new CompactionOptions().setOutputFileSizeLimit(this.targetOutputFileSize);
             CompactionJobInfo compactionJobInfo = new CompactionJobInfo();){
            this.db.compactFiles(options, cfName, files, outputLevel, 0, compactionJobInfo);
        }
    }

    public static interface CompactionTarget {
        public static final CompactionTarget NO_OP = (var1, var2, var3, var4, var5, var6) -> {};

        public void compactFiles(CompactionOptions var1, ColumnFamilyHandle var2, List<String> var3, int var4, int var5, CompactionJobInfo var6) throws RocksDBException;
    }
}

