/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.restore;

import java.util.Collection;
import java.util.Optional;
import java.util.SortedMap;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.state.rocksdb.RocksDBNativeMetricMonitor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;

public class RocksDBRestoreResult {
    private final RocksDB db;
    private final ColumnFamilyHandle defaultColumnFamilyHandle;
    private final RocksDBNativeMetricMonitor nativeMetricMonitor;
    private final long lastCompletedCheckpointId;
    private final UUID backendUID;
    private final SortedMap<Long, Collection<IncrementalKeyedStateHandle.HandleAndLocalPath>> restoredSstFiles;
    private final Runnable asyncCompactTaskAfterRestore;

    public RocksDBRestoreResult(RocksDB db, ColumnFamilyHandle defaultColumnFamilyHandle, RocksDBNativeMetricMonitor nativeMetricMonitor, long lastCompletedCheckpointId, UUID backendUID, SortedMap<Long, Collection<IncrementalKeyedStateHandle.HandleAndLocalPath>> restoredSstFiles, @Nullable Runnable asyncCompactTaskAfterRestore) {
        this.db = db;
        this.defaultColumnFamilyHandle = defaultColumnFamilyHandle;
        this.nativeMetricMonitor = nativeMetricMonitor;
        this.lastCompletedCheckpointId = lastCompletedCheckpointId;
        this.backendUID = backendUID;
        this.restoredSstFiles = restoredSstFiles;
        this.asyncCompactTaskAfterRestore = asyncCompactTaskAfterRestore;
    }

    public RocksDB getDb() {
        return this.db;
    }

    public long getLastCompletedCheckpointId() {
        return this.lastCompletedCheckpointId;
    }

    public UUID getBackendUID() {
        return this.backendUID;
    }

    public SortedMap<Long, Collection<IncrementalKeyedStateHandle.HandleAndLocalPath>> getRestoredSstFiles() {
        return this.restoredSstFiles;
    }

    public ColumnFamilyHandle getDefaultColumnFamilyHandle() {
        return this.defaultColumnFamilyHandle;
    }

    public RocksDBNativeMetricMonitor getNativeMetricMonitor() {
        return this.nativeMetricMonitor;
    }

    public Optional<Runnable> getAsyncCompactTaskAfterRestore() {
        return Optional.ofNullable(this.asyncCompactTaskAfterRestore);
    }
}

