/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.snapshot;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.CheckpointListener;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointStreamWithResultProvider;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedBackendSerializationProxy;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.PlaceholderStreamStateHandle;
import org.apache.flink.runtime.state.SnapshotResources;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.SnapshotStrategy;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.state.forst.ForStOperationUtils;
import org.apache.flink.state.forst.ForStResourceContainer;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ResourceGuard;
import org.forstdb.RocksDB;

public abstract class ForStSnapshotStrategyBase<K, R extends SnapshotResources>
implements CheckpointListener,
SnapshotStrategy<KeyedStateHandle, R>,
AutoCloseable {
    @Nonnull
    private final String description;
    @Nonnull
    protected final RocksDB db;
    @Nonnull
    protected final ResourceGuard resourceGuard;
    @Nonnull
    protected final ForStResourceContainer resourceContainer;
    @Nonnull
    protected final TypeSerializer<K> keySerializer;
    @Nonnull
    protected final LinkedHashMap<String, ForStOperationUtils.ForStKvStateInfo> kvStateInformation;
    @Nonnull
    protected final KeyGroupRange keyGroupRange;
    @Nonnegative
    protected final int keyGroupPrefixBytes;
    @Nonnull
    protected final UUID backendUID;
    protected static final PreviousSnapshot EMPTY_PREVIOUS_SNAPSHOT = new PreviousSnapshot(Collections.emptyList());

    public ForStSnapshotStrategyBase(@Nonnull String description, @Nonnull RocksDB db, @Nonnull ResourceGuard resourceGuard, @Nonnull ForStResourceContainer resourceContainer, @Nonnull TypeSerializer<K> keySerializer, @Nonnull LinkedHashMap<String, ForStOperationUtils.ForStKvStateInfo> kvStateInformation, @Nonnull KeyGroupRange keyGroupRange, @Nonnegative int keyGroupPrefixBytes, @Nonnull UUID backendUID) {
        this.db = db;
        this.resourceGuard = resourceGuard;
        this.resourceContainer = resourceContainer;
        this.keySerializer = keySerializer;
        this.kvStateInformation = kvStateInformation;
        this.keyGroupRange = keyGroupRange;
        this.keyGroupPrefixBytes = keyGroupPrefixBytes;
        this.description = description;
        this.backendUID = backendUID;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    protected abstract PreviousSnapshot snapshotMetaData(long var1, @Nonnull List<StateMetaInfoSnapshot> var3);

    @Nonnull
    protected SnapshotResult<StreamStateHandle> materializeMetaData(@Nonnull CloseableRegistry snapshotCloseableRegistry, @Nonnull CloseableRegistry tmpResourcesRegistry, @Nonnull List<StateMetaInfoSnapshot> stateMetaInfoSnapshots, long checkpointId, @Nonnull CheckpointStreamFactory checkpointStreamFactory) throws Exception {
        CheckpointStreamWithResultProvider streamWithResultProvider = CheckpointStreamWithResultProvider.createSimpleStream((CheckpointedStateScope)CheckpointedStateScope.EXCLUSIVE, (CheckpointStreamFactory)checkpointStreamFactory);
        snapshotCloseableRegistry.registerCloseable((AutoCloseable)streamWithResultProvider);
        try {
            KeyedBackendSerializationProxy serializationProxy = new KeyedBackendSerializationProxy(this.keySerializer, stateMetaInfoSnapshots, false);
            DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper((OutputStream)streamWithResultProvider.getCheckpointOutputStream());
            serializationProxy.write((DataOutputView)out);
            if (snapshotCloseableRegistry.unregisterCloseable((AutoCloseable)streamWithResultProvider)) {
                SnapshotResult result = streamWithResultProvider.closeAndFinalizeCheckpointStreamResult();
                streamWithResultProvider = null;
                tmpResourcesRegistry.registerCloseable(() -> StateUtil.discardStateObjectQuietly((StateObject)result));
                Preconditions.checkNotNull((Object)result, (String)String.format("Backend:%s, checkpoint:%s, Metadata was not properly created.", this.backendUID, checkpointId));
                Preconditions.checkNotNull((Object)((StreamStateHandle)result.getJobManagerOwnedSnapshot()), (String)String.format("Backend:%s, checkpoint:%s, Metadata for job manager was not properly created.", this.backendUID, checkpointId));
                SnapshotResult snapshotResult = result;
                return snapshotResult;
            }
            throw new IOException("Stream already closed and cannot return a handle.");
        }
        finally {
            if (snapshotCloseableRegistry.unregisterCloseable((AutoCloseable)streamWithResultProvider)) {
                IOUtils.closeQuietly((AutoCloseable)streamWithResultProvider);
            }
        }
    }

    @Override
    public abstract void close();

    protected static class PreviousSnapshot {
        @Nonnull
        private final Map<String, StreamStateHandle> confirmedSstFiles;

        protected PreviousSnapshot(@Nullable Collection<IncrementalKeyedStateHandle.HandleAndLocalPath> confirmedSstFiles) {
            this.confirmedSstFiles = confirmedSstFiles != null ? confirmedSstFiles.stream().collect(Collectors.toMap(IncrementalKeyedStateHandle.HandleAndLocalPath::getLocalPath, IncrementalKeyedStateHandle.HandleAndLocalPath::getHandle)) : Collections.emptyMap();
        }

        protected Optional<StreamStateHandle> getUploaded(String filename) {
            if (this.confirmedSstFiles.containsKey(filename)) {
                StreamStateHandle handle = this.confirmedSstFiles.get(filename);
                return Optional.of(new PlaceholderStreamStateHandle(handle.getStreamStateHandleID(), handle.getStateSize(), FileMergingSnapshotManager.isFileMergingHandle((StreamStateHandle)handle)));
            }
            return Optional.empty();
        }

        protected boolean isEmpty() {
            return this.confirmedSstFiles.isEmpty();
        }
    }

    protected static class ForStNativeSnapshotResources
    implements SnapshotResources {
        @Nonnull
        protected final List<StateMetaInfoSnapshot> stateMetaInfoSnapshots;
        protected final long manifestFileSize;
        @Nonnull
        protected final List<Path> liveFiles;
        @Nonnull
        protected final String manifestFileName;
        @Nonnull
        protected final Path manifestFilePath;
        @Nonnull
        protected PreviousSnapshot previousSnapshot;
        @Nonnull
        protected final Runnable releaser;
        private final AtomicBoolean released;

        public ForStNativeSnapshotResources(@Nonnull List<StateMetaInfoSnapshot> stateMetaInfoSnapshots, long manifestFileSize, @Nonnull List<Path> liveFiles, @Nonnull Path manifestFilePath, @Nonnull PreviousSnapshot previousSnapshot, @Nonnull Runnable releaser) {
            this.stateMetaInfoSnapshots = stateMetaInfoSnapshots;
            this.manifestFileSize = manifestFileSize;
            this.liveFiles = liveFiles;
            this.manifestFilePath = manifestFilePath;
            this.manifestFileName = manifestFilePath.getName();
            this.previousSnapshot = previousSnapshot;
            this.releaser = releaser;
            this.released = new AtomicBoolean(false);
        }

        public void setPreviousSnapshot(@Nonnull PreviousSnapshot previousSnapshot) {
            this.previousSnapshot = previousSnapshot;
        }

        public String getCurrentFileContent() {
            return this.manifestFileName + "\n";
        }

        public void release() {
            if (this.released.compareAndSet(false, true)) {
                this.releaser.run();
            }
        }
    }

    protected abstract class ForStSnapshotOperation
    implements SnapshotStrategy.SnapshotResultSupplier<KeyedStateHandle> {
        protected final long checkpointId;
        @Nonnull
        protected final CheckpointStreamFactory checkpointStreamFactory;
        @Nonnull
        protected final CloseableRegistry tmpResourcesRegistry;

        protected ForStSnapshotOperation(@Nonnull long checkpointId, CheckpointStreamFactory checkpointStreamFactory) {
            this.checkpointId = checkpointId;
            this.checkpointStreamFactory = checkpointStreamFactory;
            this.tmpResourcesRegistry = new CloseableRegistry();
        }
    }
}

