/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs.filemapping;

import org.apache.flink.core.fs.Path;
import org.apache.flink.state.forst.fs.filemapping.FileOwnership;

public class FileOwnershipDecider {
    public static final String SST_SUFFIX = ".sst";

    private FileOwnershipDecider() {
    }

    public static FileOwnership decideForNewFile(Path filePath) {
        return FileOwnershipDecider.shouldAlwaysBeLocal(filePath) ? FileOwnership.PRIVATE_OWNED_BY_DB : FileOwnership.SHAREABLE_OWNED_BY_DB;
    }

    public static FileOwnership decideForRestoredFile(Path filePath) {
        return FileOwnershipDecider.shouldAlwaysBeLocal(filePath) ? FileOwnership.PRIVATE_OWNED_BY_DB : FileOwnership.NOT_OWNED;
    }

    public static boolean isSstFile(Path filePath) {
        return filePath.getName().endsWith(SST_SUFFIX);
    }

    public static boolean shouldAlwaysBeLocal(Path filePath, FileOwnership fileOwnership) {
        return !FileOwnershipDecider.isSstFile(filePath) && fileOwnership != FileOwnership.NOT_OWNED;
    }

    public static boolean shouldAlwaysBeLocal(Path filePath) {
        return !FileOwnershipDecider.isSstFile(filePath);
    }
}

