/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import org.forstdb.Cache;
import org.forstdb.WriteBufferManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ForStSharedResources
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ForStSharedResources.class);
    private final Cache cache;
    private final WriteBufferManager writeBufferManager;
    private final long writeBufferManagerCapacity;
    private final boolean usingPartitionedIndexFilters;

    ForStSharedResources(Cache cache, WriteBufferManager writeBufferManager, long writeBufferManagerCapacity, boolean usingPartitionedIndexFilters) {
        this.cache = cache;
        this.writeBufferManager = writeBufferManager;
        this.writeBufferManagerCapacity = writeBufferManagerCapacity;
        this.usingPartitionedIndexFilters = usingPartitionedIndexFilters;
    }

    public Cache getCache() {
        return this.cache;
    }

    public WriteBufferManager getWriteBufferManager() {
        return this.writeBufferManager;
    }

    public long getWriteBufferManagerCapacity() {
        return this.writeBufferManagerCapacity;
    }

    public boolean isUsingPartitionedIndexFilters() {
        return this.usingPartitionedIndexFilters;
    }

    @Override
    public void close() {
        LOG.debug("Closing ForStSharedResources");
        this.writeBufferManager.close();
        this.cache.close();
    }
}

