/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.state.forst.ForStResourceContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForStPathContainer {
    private static final Logger LOG = LoggerFactory.getLogger(ForStResourceContainer.class);
    public static final String DB_DIR_STRING = "db";
    @Nullable
    private final Path localJobPath;
    @Nullable
    private final Path localBasePath;
    @Nullable
    private final Path localForStPath;
    @Nullable
    private final Path remoteJobPath;
    @Nullable
    private final Path remoteBasePath;
    @Nullable
    private final Path remoteForStPath;

    public static ForStPathContainer empty() {
        return ForStPathContainer.of(null, null, null, null);
    }

    public static ForStPathContainer ofLocal(@Nullable Path localJobPath, @Nullable Path localBasePath) {
        return new ForStPathContainer(localJobPath, localBasePath, null, null);
    }

    public static ForStPathContainer of(@Nullable Path localJobPath, @Nullable Path localBasePath, @Nullable Path remoteJobPath, @Nullable Path remoteBasePath) {
        return new ForStPathContainer(localJobPath, localBasePath, remoteJobPath, remoteBasePath);
    }

    public ForStPathContainer(@Nullable Path localJobPath, @Nullable Path localBasePath, @Nullable Path remoteJobPath, @Nullable Path remoteBasePath) {
        this.localJobPath = localJobPath;
        this.localBasePath = localBasePath;
        this.localForStPath = localBasePath != null ? new Path(localBasePath, DB_DIR_STRING) : null;
        this.remoteJobPath = remoteJobPath;
        this.remoteBasePath = remoteBasePath;
        this.remoteForStPath = remoteBasePath != null ? new Path(remoteBasePath, DB_DIR_STRING) : null;
        LOG.info("ForStPathContainer: localJobPath: {}, localBasePath: {}, localForStPath:{},  remoteJobPath: {}, remoteBasePath: {}, remoteForStPath: {}", new Object[]{localJobPath, localBasePath, this.localForStPath, remoteJobPath, remoteBasePath, this.remoteForStPath});
    }

    @Nullable
    public Path getLocalJobPath() {
        return this.localJobPath;
    }

    @Nullable
    public Path getLocalBasePath() {
        return this.localBasePath;
    }

    @Nullable
    public Path getLocalForStPath() {
        return this.localForStPath;
    }

    @Nullable
    public Path getRemoteJobPath() {
        return this.remoteJobPath;
    }

    @Nullable
    public Path getRemoteBasePath() {
        return this.remoteBasePath;
    }

    @Nullable
    public Path getRemoteForStPath() {
        return this.remoteForStPath;
    }

    public Path getJobPath() {
        if (this.remoteJobPath != null) {
            return this.remoteJobPath;
        }
        return this.localJobPath;
    }

    public Path getBasePath() {
        if (this.remoteBasePath != null) {
            return this.remoteBasePath;
        }
        return this.localBasePath;
    }

    public Path getDbPath() {
        if (this.remoteForStPath != null) {
            return this.remoteForStPath;
        }
        return this.localForStPath;
    }

    public String toString() {
        return "ForStPathContainer(localJobPath = [" + this.localJobPath + "] localBasePath = [" + this.localBasePath + "] localForStPath = [" + this.localForStPath + "] remoteJobPath = [" + this.remoteJobPath + "] remoteBasePath = [" + this.remoteBasePath + "] remoteForStPath = [" + this.remoteForStPath + "])";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForStPathContainer that = (ForStPathContainer)o;
        return Objects.equals(this.localJobPath, that.localJobPath) && Objects.equals(this.localBasePath, that.localBasePath) && Objects.equals(this.localForStPath, that.localForStPath) && Objects.equals(this.remoteJobPath, that.remoteJobPath) && Objects.equals(this.remoteBasePath, that.remoteBasePath) && Objects.equals(this.remoteForStPath, that.remoteForStPath);
    }

    public int hashCode() {
        return Objects.hash(this.localJobPath, this.localBasePath, this.localForStPath, this.remoteJobPath, this.remoteBasePath, this.remoteForStPath);
    }
}

