/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs.cache;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.state.forst.fs.cache.CacheLimitPolicy;

public class BundledCacheLimitPolicy
implements CacheLimitPolicy {
    private Collection<CacheLimitPolicy> policies = new ArrayList<CacheLimitPolicy>();

    public BundledCacheLimitPolicy(CacheLimitPolicy ... inputPolicies) {
        for (CacheLimitPolicy policy : inputPolicies) {
            this.policies.add(policy);
        }
    }

    @Override
    public boolean directWriteInCache() {
        return this.policies.stream().allMatch(CacheLimitPolicy::directWriteInCache);
    }

    @Override
    public boolean isSafeToAdd(long toAddSize) {
        return this.policies.stream().allMatch(policy -> policy.isSafeToAdd(toAddSize));
    }

    @Override
    public boolean isOverflow(long toAddSize, boolean hasFile) {
        return this.policies.stream().anyMatch(policy -> policy.isOverflow(toAddSize, hasFile));
    }

    @Override
    public void acquire(long toAddSize) {
        this.policies.forEach(policy -> policy.acquire(toAddSize));
    }

    @Override
    public void release(long toReleaseSize) {
        this.policies.forEach(policy -> policy.release(toReleaseSize));
    }

    @Override
    public long usedBytes() {
        return this.policies.stream().mapToLong(CacheLimitPolicy::usedBytes).max().getAsLong();
    }

    @Override
    public void registerCustomizedMetrics(String prefix, MetricGroup metricGroup) {
        this.policies.forEach(policy -> policy.registerCustomizedMetrics(prefix, metricGroup));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BundledCacheLimitPolicy{");
        for (CacheLimitPolicy policy : this.policies) {
            sb.append(policy.toString()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

