/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class CommitUtilsWithMR {
    private CommitUtilsWithMR() {
    }

    public static Path getMagicJobAttemptsPath(Path out) {
        return new Path(out, "__magic");
    }

    public static int getAppAttemptId(JobContext context) {
        return context.getConfiguration().getInt("mapreduce.job.application.attempt.id", 0);
    }

    public static Path getMagicJobAttemptPath(String jobUUID, Path dest) {
        return new Path(CommitUtilsWithMR.getMagicJobAttemptsPath(dest), CommitUtilsWithMR.formatAppAttemptDir(jobUUID));
    }

    public static String formatAppAttemptDir(String jobUUID) {
        return String.format("job-%s", jobUUID);
    }

    public static Path getMagicTaskAttemptsPath(String jobUUID, Path dest) {
        return new Path(CommitUtilsWithMR.getMagicJobAttemptPath(jobUUID, dest), "tasks");
    }

    public static Path getMagicTaskAttemptPath(TaskAttemptContext context, String jobUUID, Path dest) {
        return new Path(CommitUtilsWithMR.getBaseMagicTaskAttemptPath(context, jobUUID, dest), "__base");
    }

    public static Path getBaseMagicTaskAttemptPath(TaskAttemptContext context, String jobUUID, Path dest) {
        return new Path(CommitUtilsWithMR.getMagicTaskAttemptsPath(jobUUID, dest), String.valueOf(context.getTaskAttemptID()));
    }

    public static Path getTempJobAttemptPath(String jobUUID, Path out) {
        return new Path(new Path(out, "__temp-data"), CommitUtilsWithMR.formatAppAttemptDir(jobUUID));
    }

    public static Path getTempTaskAttemptPath(TaskAttemptContext context, String jobUUID, Path out) {
        return new Path(CommitUtilsWithMR.getTempJobAttemptPath(jobUUID, out), String.valueOf(context.getTaskAttemptID()));
    }

    public static String jobIdString(JobContext context) {
        JobID jobID = context.getJobID();
        return jobID != null ? jobID.toString() : "(no job ID)";
    }

    public static String jobName(JobContext context) {
        String name = context.getJobName();
        return name != null && !name.isEmpty() ? name : "(anonymous)";
    }

    public static String getConfigurationOption(JobContext context, Configuration fsConf, String key, String defVal) {
        return context.getConfiguration().getTrimmed(key, fsConf.getTrimmed(key, defVal));
    }
}

