/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.operators.collect.CollectCoordinationResponse;
import org.apache.flink.util.Preconditions;

public abstract class AbstractCollectResultBuffer<T> {
    private static final String INIT_VERSION = "";
    private final TypeSerializer<T> serializer;
    private final LinkedList<T> buffer;
    private String version;
    private long offset;
    private long userVisibleHead;
    private long userVisibleTail;

    public AbstractCollectResultBuffer(TypeSerializer<T> serializer) {
        this.serializer = serializer;
        this.buffer = new LinkedList();
        this.version = INIT_VERSION;
        this.offset = 0L;
        this.userVisibleHead = 0L;
        this.userVisibleTail = 0L;
    }

    public T next() {
        if (this.userVisibleHead == this.userVisibleTail) {
            return null;
        }
        T ret = this.buffer.removeFirst();
        ++this.userVisibleHead;
        this.sanityCheck();
        return ret;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getVersion() {
        return this.version;
    }

    public void dealWithResponse(CollectCoordinationResponse response, long responseOffset) throws IOException {
        String responseVersion = response.getVersion();
        long responseLastCheckpointedOffset = response.getLastCheckpointedOffset();
        if (!INIT_VERSION.equals(this.version) && !this.version.equals(responseVersion)) {
            this.sinkRestarted(responseLastCheckpointedOffset);
        }
        this.version = responseVersion;
        this.addResults(response, responseOffset);
        this.maintainVisibility(this.userVisibleTail, responseLastCheckpointedOffset);
        this.sanityCheck();
    }

    public void complete() {
        this.makeResultsVisible(this.offset);
    }

    protected abstract void sinkRestarted(long var1);

    protected abstract void maintainVisibility(long var1, long var3);

    protected void makeResultsVisible(long visiblePos) {
        this.userVisibleTail = visiblePos;
    }

    protected void revert(long checkpointedOffset) {
        while (this.offset > checkpointedOffset) {
            this.buffer.removeLast();
            --this.offset;
        }
    }

    protected void reset() {
        this.buffer.clear();
        this.userVisibleHead = 0L;
        this.userVisibleTail = 0L;
        this.offset = 0L;
    }

    private void addResults(CollectCoordinationResponse response, long responseOffset) throws IOException {
        List<T> results = response.getResults(this.serializer);
        if (!results.isEmpty()) {
            int addStart = (int)(this.offset - responseOffset);
            if (addStart > results.size()) {
                return;
            }
            List<T> addedResults = results.subList(addStart, results.size());
            this.buffer.addAll(addedResults);
            this.offset += (long)addedResults.size();
        }
    }

    private void sanityCheck() {
        Preconditions.checkState((this.userVisibleHead <= this.userVisibleTail ? 1 : 0) != 0, (Object)"userVisibleHead should not be larger than userVisibleTail. This is a bug.");
        Preconditions.checkState((this.userVisibleTail <= this.offset ? 1 : 0) != 0, (Object)"userVisibleTail should not be larger than offset. This is a bug.");
    }
}

