/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.InputStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OutputStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class OperatorSnapshotFinalizer {
    private final OperatorSubtaskState jobManagerOwnedState;
    private final OperatorSubtaskState taskLocalState;

    public static OperatorSnapshotFinalizer create(OperatorSnapshotFutures snapshotFutures) throws ExecutionException, InterruptedException {
        Preconditions.checkNotNull((Object)snapshotFutures);
        SnapshotResult keyedManaged = (SnapshotResult)FutureUtils.runIfNotDoneAndGet(snapshotFutures.getKeyedStateManagedFuture());
        SnapshotResult keyedRaw = (SnapshotResult)FutureUtils.runIfNotDoneAndGet(snapshotFutures.getKeyedStateRawFuture());
        SnapshotResult operatorManaged = (SnapshotResult)FutureUtils.runIfNotDoneAndGet(snapshotFutures.getOperatorStateManagedFuture());
        SnapshotResult operatorRaw = (SnapshotResult)FutureUtils.runIfNotDoneAndGet(snapshotFutures.getOperatorStateRawFuture());
        SnapshotResult<StateObjectCollection<InputStateHandle>> inputChannel = snapshotFutures.getInputChannelStateFuture().get();
        SnapshotResult<StateObjectCollection<OutputStateHandle>> resultSubpartition = snapshotFutures.getResultSubpartitionStateFuture().get();
        OperatorSubtaskState jobManagerOwnedState = OperatorSubtaskState.builder().setManagedOperatorState(StateObjectCollection.singletonOrEmpty((OperatorStateHandle)operatorManaged.getJobManagerOwnedSnapshot())).setRawOperatorState(StateObjectCollection.singletonOrEmpty((OperatorStateHandle)operatorRaw.getJobManagerOwnedSnapshot())).setManagedKeyedState(StateObjectCollection.singletonOrEmpty((KeyedStateHandle)keyedManaged.getJobManagerOwnedSnapshot())).setRawKeyedState(StateObjectCollection.singletonOrEmpty((KeyedStateHandle)keyedRaw.getJobManagerOwnedSnapshot())).setInputChannelState(StateObjectCollection.emptyIfNull(inputChannel.getJobManagerOwnedSnapshot())).setResultSubpartitionState(StateObjectCollection.emptyIfNull(resultSubpartition.getJobManagerOwnedSnapshot())).build();
        OperatorSubtaskState taskLocalState = OperatorSubtaskState.builder().setManagedOperatorState(StateObjectCollection.singletonOrEmpty((OperatorStateHandle)operatorManaged.getTaskLocalSnapshot())).setRawOperatorState(StateObjectCollection.singletonOrEmpty((OperatorStateHandle)operatorRaw.getTaskLocalSnapshot())).setManagedKeyedState(StateObjectCollection.singletonOrEmpty((KeyedStateHandle)keyedManaged.getTaskLocalSnapshot())).setRawKeyedState(StateObjectCollection.singletonOrEmpty((KeyedStateHandle)keyedRaw.getTaskLocalSnapshot())).setInputChannelState(StateObjectCollection.emptyIfNull(inputChannel.getTaskLocalSnapshot())).setResultSubpartitionState(StateObjectCollection.emptyIfNull(resultSubpartition.getTaskLocalSnapshot())).build();
        return new OperatorSnapshotFinalizer(jobManagerOwnedState, taskLocalState);
    }

    public OperatorSnapshotFinalizer(OperatorSubtaskState jobManagerOwnedState, OperatorSubtaskState taskLocalState) {
        this.jobManagerOwnedState = (OperatorSubtaskState)Preconditions.checkNotNull((Object)jobManagerOwnedState);
        this.taskLocalState = (OperatorSubtaskState)Preconditions.checkNotNull((Object)taskLocalState);
    }

    public OperatorSubtaskState getTaskLocalState() {
        return this.taskLocalState;
    }

    public OperatorSubtaskState getJobManagerOwnedState() {
        return this.jobManagerOwnedState;
    }
}

