/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.event.WatermarkEvent;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.WatermarkGaugeExposingOutput;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.OutputTag;

public class CountingOutput<OUT>
implements WatermarkGaugeExposingOutput<StreamRecord<OUT>> {
    private final WatermarkGaugeExposingOutput<StreamRecord<OUT>> output;
    private final Counter numRecordsOut;

    public CountingOutput(WatermarkGaugeExposingOutput<StreamRecord<OUT>> output, Counter numRecordsOut) {
        this.output = output;
        this.numRecordsOut = numRecordsOut;
    }

    @Override
    public void emitWatermark(Watermark mark) {
        this.output.emitWatermark(mark);
    }

    @Override
    public void emitWatermarkStatus(WatermarkStatus watermarkStatus) {
        this.output.emitWatermarkStatus(watermarkStatus);
    }

    @Override
    public void emitLatencyMarker(LatencyMarker latencyMarker) {
        this.output.emitLatencyMarker(latencyMarker);
    }

    public void collect(StreamRecord<OUT> record) {
        this.numRecordsOut.inc();
        this.output.collect(record);
    }

    @Override
    public <X> void collect(OutputTag<X> outputTag, StreamRecord<X> record) {
        this.numRecordsOut.inc();
        this.output.collect(outputTag, record);
    }

    @Override
    public void close() {
        this.output.close();
    }

    @Override
    public Gauge<Long> getWatermarkGauge() {
        return this.output.getWatermarkGauge();
    }

    @Override
    public void emitRecordAttributes(RecordAttributes recordAttributes) {
        this.output.emitRecordAttributes(recordAttributes);
    }

    @Override
    public void emitWatermark(WatermarkEvent watermark) {
        this.output.emitWatermark(watermark);
    }
}

