/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationFileMigrationUtils;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.entrypoint.ClusterConfiguration;
import org.apache.flink.runtime.entrypoint.ClusterConfigurationParserFactory;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.entrypoint.ModifiableClusterConfiguration;
import org.apache.flink.runtime.entrypoint.ModifiableClusterConfigurationParserFactory;
import org.apache.flink.runtime.entrypoint.parser.CommandLineParser;
import org.apache.flink.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationParserUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationParserUtils.class);

    public static int getSlot(Configuration configuration) {
        int slots = (Integer)configuration.get(TaskManagerOptions.NUM_TASK_SLOTS, (Object)1);
        if (slots == -1) {
            slots = 1;
        }
        ConfigurationParserUtils.checkConfigParameter(slots >= 1, slots, TaskManagerOptions.NUM_TASK_SLOTS.key(), "Number of task slots must be at least one.");
        return slots;
    }

    public static void checkConfigParameter(boolean condition, Object parameter, String name, String errorMessage) throws IllegalConfigurationException {
        if (!condition) {
            throw new IllegalConfigurationException("Invalid configuration value for " + name + " : " + parameter + " - " + errorMessage);
        }
    }

    public static int getPageSize(Configuration configuration) {
        int pageSize = MathUtils.checkedDownCast((long)((MemorySize)configuration.get(TaskManagerOptions.MEMORY_SEGMENT_SIZE)).getBytes());
        ConfigurationParserUtils.checkConfigParameter(pageSize >= 4096, pageSize, TaskManagerOptions.MEMORY_SEGMENT_SIZE.key(), "Minimum memory segment size is 4096");
        ConfigurationParserUtils.checkConfigParameter(MathUtils.isPowerOf2((long)pageSize), pageSize, TaskManagerOptions.MEMORY_SEGMENT_SIZE.key(), "Memory segment size must be a power of 2.");
        return pageSize;
    }

    public static Configuration loadCommonConfiguration(String[] args, String cmdLineSyntax) throws FlinkParseException {
        ClusterConfiguration clusterConfiguration;
        CommandLineParser<ClusterConfiguration> commandLineParser = new CommandLineParser<ClusterConfiguration>(new ClusterConfigurationParserFactory());
        try {
            clusterConfiguration = commandLineParser.parse(args);
        }
        catch (FlinkParseException e) {
            LOG.error("Could not parse the command line options.", (Throwable)((Object)e));
            commandLineParser.printHelp(cmdLineSyntax);
            throw e;
        }
        Configuration dynamicProperties = ConfigurationUtils.createConfiguration((Properties)clusterConfiguration.getDynamicProperties());
        return GlobalConfiguration.loadConfiguration((String)clusterConfiguration.getConfigDir(), (Configuration)dynamicProperties);
    }

    public static List<String> loadAndModifyConfiguration(String[] args, String cmdLineSyntax) throws FlinkParseException {
        ModifiableClusterConfiguration modifiableClusterConfiguration;
        CommandLineParser<ModifiableClusterConfiguration> commandLineParser = new CommandLineParser<ModifiableClusterConfiguration>(new ModifiableClusterConfigurationParserFactory());
        try {
            modifiableClusterConfiguration = commandLineParser.parse(args);
        }
        catch (FlinkParseException e) {
            LOG.error("Could not parse the command line options.", (Throwable)((Object)e));
            commandLineParser.printHelp(cmdLineSyntax);
            throw e;
        }
        Configuration dynamicProperties = ConfigurationUtils.createConfiguration((Properties)modifiableClusterConfiguration.getDynamicProperties());
        Configuration configuration = GlobalConfiguration.loadConfiguration((String)modifiableClusterConfiguration.getConfigDir(), (Configuration)dynamicProperties);
        List<Tuple3<String, String, String>> replaceKeyValues = modifiableClusterConfiguration.getReplaceKeyValues();
        replaceKeyValues.forEach(tuple3 -> {
            String key = (String)tuple3.f0;
            String oldValue = (String)tuple3.f1;
            String newValue = (String)tuple3.f2;
            if (oldValue.equals(configuration.get(ConfigOptions.key((String)key).stringType().noDefaultValue()))) {
                configuration.setString(key, newValue);
            }
        });
        Properties removeKeyValues = modifiableClusterConfiguration.getRemoveKeyValues();
        Set<String> propertyNames = removeKeyValues.stringPropertyNames();
        for (String propertyName : propertyNames) {
            if (!removeKeyValues.getProperty(propertyName).equals(configuration.get(ConfigOptions.key((String)propertyName).stringType().noDefaultValue()))) continue;
            configuration.removeKey(propertyName);
        }
        List<String> removeKeys = modifiableClusterConfiguration.getRemoveKeys();
        removeKeys.forEach(arg_0 -> ((Configuration)configuration).removeKey(arg_0));
        return ConfigurationUtils.convertConfigToWritableLines((Configuration)configuration, (boolean)modifiableClusterConfiguration.flattenConfig());
    }

    public static List<String> migrateLegacyConfigurationToStandardYaml(String[] args, String cmdLineSyntax) throws FlinkParseException {
        ClusterConfiguration clusterConfiguration;
        CommandLineParser<ClusterConfiguration> commandLineParser = new CommandLineParser<ClusterConfiguration>(new ClusterConfigurationParserFactory());
        try {
            clusterConfiguration = commandLineParser.parse(args);
        }
        catch (FlinkParseException e) {
            LOG.error("Could not parse the command line options.", (Throwable)((Object)e));
            commandLineParser.printHelp(cmdLineSyntax);
            throw e;
        }
        return ConfigurationUtils.convertConfigToWritableLines((Configuration)ConfigurationFileMigrationUtils.migrateLegacyToStandardYamlConfig((String)clusterConfiguration.getConfigDir()), (boolean)false);
    }
}

