/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.state.v2.internal.InternalKeyedState;

@Internal
public abstract class AbstractKeyedState<K, N, V>
implements InternalKeyedState<K, N, V> {
    protected final StateRequestHandler stateRequestHandler;
    private final ThreadLocal<TypeSerializer<V>> valueSerializer;

    public AbstractKeyedState(StateRequestHandler stateRequestHandler, TypeSerializer<V> valueSerializer) {
        this.stateRequestHandler = stateRequestHandler;
        this.valueSerializer = ThreadLocal.withInitial(() -> valueSerializer.duplicate());
    }

    protected final <IN, OUT> StateFuture<OUT> handleRequest(StateRequestType stateRequestType, IN payload) {
        return this.stateRequestHandler.handleRequest(this, stateRequestType, payload);
    }

    protected final <IN, OUT> OUT handleRequestSync(StateRequestType stateRequestType, IN payload) {
        return this.stateRequestHandler.handleRequestSync(this, stateRequestType, payload);
    }

    @Override
    public void setCurrentNamespace(N namespace) {
        this.stateRequestHandler.setCurrentNamespaceForState(this, namespace);
    }

    public final StateFuture<Void> asyncClear() {
        return this.handleRequest(StateRequestType.CLEAR, null);
    }

    public final void clear() {
        this.handleRequestSync(StateRequestType.CLEAR, null);
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer.get();
    }

    public StateRequestHandler getStateRequestHandler() {
        return this.stateRequestHandler;
    }
}

