/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.metrics;

import java.util.Locale;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.scheduler.metrics.MetricsRegistrar;
import org.apache.flink.runtime.scheduler.metrics.StateTimeMetric;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class JobStatusMetrics
implements JobStatusListener,
MetricsRegistrar {
    private final MetricOptions.JobStatusMetricsSettings jobStatusMetricsSettings;
    private JobStatus currentStatus = JobStatus.INITIALIZING;
    private long currentStatusTimestamp;
    private final long[] cumulativeStatusTimes;
    private final Clock clock;

    public JobStatusMetrics(long initializationTimestamp, MetricOptions.JobStatusMetricsSettings jobStatusMetricsSettings) {
        this(initializationTimestamp, jobStatusMetricsSettings, (Clock)SystemClock.getInstance());
    }

    @VisibleForTesting
    JobStatusMetrics(long initializationTimestamp, MetricOptions.JobStatusMetricsSettings jobStatusMetricsSettings, Clock clock) {
        this.jobStatusMetricsSettings = jobStatusMetricsSettings;
        this.clock = clock;
        this.currentStatus = JobStatus.INITIALIZING;
        this.currentStatusTimestamp = initializationTimestamp;
        this.cumulativeStatusTimes = new long[JobStatus.values().length];
    }

    @Override
    public void registerMetrics(MetricGroup metricGroup) {
        for (JobStatus jobStatus : JobStatus.values()) {
            if (jobStatus.isTerminalState() || jobStatus == JobStatus.RECONCILING) continue;
            StateTimeMetric stateTimeMetric = this.createTimeMetric(jobStatus);
            StateTimeMetric.register(this.jobStatusMetricsSettings, metricGroup, stateTimeMetric, JobStatusMetrics.getBaseMetricName(jobStatus));
        }
    }

    @VisibleForTesting
    StateTimeMetric createTimeMetric(final JobStatus jobStatus) {
        return new StateTimeMetric(){

            @Override
            public long getCurrentTime() {
                return JobStatusMetrics.this.currentStatus == jobStatus ? Math.max(JobStatusMetrics.this.clock.absoluteTimeMillis() - JobStatusMetrics.this.currentStatusTimestamp, 0L) : 0L;
            }

            @Override
            public long getTotalTime() {
                return JobStatusMetrics.this.currentStatus == jobStatus ? JobStatusMetrics.this.cumulativeStatusTimes[jobStatus.ordinal()] + Math.max(JobStatusMetrics.this.clock.absoluteTimeMillis() - JobStatusMetrics.this.currentStatusTimestamp, 0L) : JobStatusMetrics.this.cumulativeStatusTimes[jobStatus.ordinal()];
            }

            @Override
            public long getBinary() {
                return JobStatusMetrics.this.currentStatus == jobStatus ? 1L : 0L;
            }
        };
    }

    @VisibleForTesting
    static String getBaseMetricName(JobStatus jobStatus) {
        return jobStatus.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public void jobStatusChanges(JobID jobId, JobStatus newJobStatus, long timestamp) {
        int n = this.currentStatus.ordinal();
        this.cumulativeStatusTimes[n] = this.cumulativeStatusTimes[n] + (timestamp - this.currentStatusTimestamp);
        this.currentStatus = newJobStatus;
        this.currentStatusTimestamp = timestamp;
    }
}

