/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateTransitions;
import org.slf4j.Logger;

abstract class StateWithoutExecutionGraph
implements State {
    private final Context context;
    private final Logger logger;

    StateWithoutExecutionGraph(Context context, Logger logger) {
        this.context = context;
        this.logger = logger;
    }

    @Override
    public void cancel() {
        this.context.goToFinished(this.context.getArchivedExecutionGraph(JobStatus.CANCELED, null));
    }

    @Override
    public void suspend(Throwable cause) {
        this.context.goToFinished(this.context.getArchivedExecutionGraph(JobStatus.SUSPENDED, cause));
    }

    @Override
    public JobID getJobId() {
        return this.context.getJobId();
    }

    @Override
    public ArchivedExecutionGraph getJob() {
        return this.context.getArchivedExecutionGraph(this.getJobStatus(), null);
    }

    @Override
    public void handleGlobalFailure(Throwable cause, CompletableFuture<Map<String, String>> failureLabels) {
        this.context.goToFinished(this.context.getArchivedExecutionGraph(JobStatus.FAILED, cause));
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    static interface Context
    extends StateTransitions.ToFinished {
        public JobID getJobId();

        public ArchivedExecutionGraph getArchivedExecutionGraph(JobStatus var1, @Nullable Throwable var2);
    }
}

