/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.runtime.rest.HttpHeader;
import org.apache.flink.runtime.rest.HttpMethodWrapper;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.versioning.RestAPIVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;

public class CustomHeadersDecorator<R extends RequestBody, P extends ResponseBody, M extends MessageParameters>
implements MessageHeaders<R, P, M> {
    private final MessageHeaders<R, P, M> decorated;
    private Collection<HttpHeader> customHeaders;

    public CustomHeadersDecorator(MessageHeaders<R, P, M> decorated) {
        this.decorated = decorated;
    }

    @Override
    public HttpMethodWrapper getHttpMethod() {
        return this.decorated.getHttpMethod();
    }

    @Override
    public String getTargetRestEndpointURL() {
        return this.decorated.getTargetRestEndpointURL();
    }

    @Override
    public Collection<? extends RestAPIVersion<?>> getSupportedAPIVersions() {
        return this.decorated.getSupportedAPIVersions();
    }

    @Override
    public Class<P> getResponseClass() {
        return this.decorated.getResponseClass();
    }

    @Override
    public HttpResponseStatus getResponseStatusCode() {
        return this.decorated.getResponseStatusCode();
    }

    @Override
    public String getDescription() {
        return this.decorated.getDescription();
    }

    @Override
    public Class<R> getRequestClass() {
        return this.decorated.getRequestClass();
    }

    @Override
    public M getUnresolvedMessageParameters() {
        return this.decorated.getUnresolvedMessageParameters();
    }

    @Override
    public Collection<HttpHeader> getCustomHeaders() {
        return this.customHeaders;
    }

    @Override
    public Collection<Class<?>> getResponseTypeParameters() {
        return this.decorated.getResponseTypeParameters();
    }

    public void setCustomHeaders(Collection<HttpHeader> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public void addCustomHeader(HttpHeader httpHeader) {
        if (this.customHeaders == null) {
            this.customHeaders = new ArrayList<HttpHeader>();
        }
        this.customHeaders.add(httpHeader);
    }

    public MessageHeaders<R, P, M> getDecorated() {
        return this.decorated;
    }
}

