/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedTaskManagerRegistration;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedTaskManagerSlot;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManagerId;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerUtils;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotState;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerInfo;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerTracker;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FineGrainedTaskManagerTracker
implements TaskManagerTracker {
    private static final Logger LOG = LoggerFactory.getLogger(FineGrainedTaskManagerTracker.class);
    private final Map<AllocationID, FineGrainedTaskManagerSlot> slots;
    private final Map<InstanceID, FineGrainedTaskManagerRegistration> taskManagerRegistrations;
    private final Map<InstanceID, WorkerResourceSpec> unWantedTaskManagers;
    private final Map<PendingTaskManagerId, PendingTaskManager> pendingTaskManagers;
    private ResourceProfile totalRegisteredResource = ResourceProfile.ZERO;
    private ResourceProfile totalPendingResource = ResourceProfile.ZERO;
    private final Map<Tuple2<ResourceProfile, ResourceProfile>, Set<PendingTaskManager>> totalAndDefaultSlotProfilesToPendingTaskManagers;

    public FineGrainedTaskManagerTracker() {
        this.slots = new HashMap<AllocationID, FineGrainedTaskManagerSlot>();
        this.taskManagerRegistrations = new HashMap<InstanceID, FineGrainedTaskManagerRegistration>();
        this.unWantedTaskManagers = new HashMap<InstanceID, WorkerResourceSpec>();
        this.pendingTaskManagers = new HashMap<PendingTaskManagerId, PendingTaskManager>();
        this.totalAndDefaultSlotProfilesToPendingTaskManagers = new HashMap<Tuple2<ResourceProfile, ResourceProfile>, Set<PendingTaskManager>>();
    }

    @Override
    public void replaceAllPendingAllocations(Map<PendingTaskManagerId, Map<JobID, ResourceCounter>> pendingSlotAllocations) {
        Preconditions.checkNotNull(pendingSlotAllocations);
        LOG.trace("Record the pending allocations {}.", pendingSlotAllocations);
        this.pendingTaskManagers.values().forEach(PendingTaskManager::clearAllPendingAllocations);
        pendingSlotAllocations.forEach((pendingTaskManagerId, jobIDResourceCounterMap) -> ((PendingTaskManager)Preconditions.checkNotNull((Object)this.pendingTaskManagers.get(pendingTaskManagerId))).replaceAllPendingAllocations((Map<JobID, ResourceCounter>)jobIDResourceCounterMap));
    }

    @Override
    public void clearPendingAllocationsOfJob(JobID jobId) {
        LOG.info("Clear all pending allocations for job {}.", (Object)jobId);
        this.pendingTaskManagers.values().forEach(pendingTaskManager -> pendingTaskManager.clearPendingAllocationsOfJob(jobId));
    }

    @Override
    public void addTaskManager(TaskExecutorConnection taskExecutorConnection, ResourceProfile totalResourceProfile, ResourceProfile defaultSlotResourceProfile) {
        Preconditions.checkNotNull((Object)taskExecutorConnection);
        Preconditions.checkNotNull((Object)totalResourceProfile);
        Preconditions.checkNotNull((Object)defaultSlotResourceProfile);
        LOG.debug("Add task manager {} with total resource {} and default slot resource {}.", new Object[]{taskExecutorConnection.getInstanceID(), totalResourceProfile, defaultSlotResourceProfile});
        FineGrainedTaskManagerRegistration taskManagerRegistration = new FineGrainedTaskManagerRegistration(taskExecutorConnection, totalResourceProfile, defaultSlotResourceProfile);
        this.taskManagerRegistrations.put(taskExecutorConnection.getInstanceID(), taskManagerRegistration);
        this.totalRegisteredResource = this.totalRegisteredResource.merge(totalResourceProfile);
    }

    @Override
    public void removeTaskManager(InstanceID instanceId) {
        Preconditions.checkNotNull((Object)((Object)instanceId));
        this.unWantedTaskManagers.remove((Object)instanceId);
        FineGrainedTaskManagerRegistration taskManager = (FineGrainedTaskManagerRegistration)Preconditions.checkNotNull((Object)this.taskManagerRegistrations.remove((Object)instanceId));
        this.totalRegisteredResource = this.totalRegisteredResource.subtract(taskManager.getTotalResource());
        LOG.debug("Remove task manager {}.", (Object)instanceId);
        for (AllocationID allocationId : taskManager.getAllocatedSlots().keySet()) {
            this.slots.remove((Object)allocationId);
        }
    }

    @Override
    public void addUnWantedTaskManager(InstanceID instanceId) {
        FineGrainedTaskManagerRegistration taskManager = this.taskManagerRegistrations.get((Object)instanceId);
        if (taskManager != null) {
            this.unWantedTaskManagers.put(instanceId, WorkerResourceSpec.fromTotalResourceProfile(taskManager.getTotalResource(), SlotManagerUtils.calculateDefaultNumSlots(taskManager.getTotalResource(), taskManager.getDefaultSlotResourceProfile())));
        } else {
            LOG.debug("Unwanted task manager {} does not exists.", (Object)instanceId);
        }
    }

    @Override
    public Map<InstanceID, WorkerResourceSpec> getUnWantedTaskManager() {
        return this.unWantedTaskManagers;
    }

    @Override
    public void addPendingTaskManager(PendingTaskManager pendingTaskManager) {
        Preconditions.checkNotNull((Object)pendingTaskManager);
        LOG.debug("Add pending task manager {}.", (Object)pendingTaskManager);
        this.pendingTaskManagers.put(pendingTaskManager.getPendingTaskManagerId(), pendingTaskManager);
        this.totalPendingResource = this.totalPendingResource.merge(pendingTaskManager.getTotalResourceProfile());
        this.totalAndDefaultSlotProfilesToPendingTaskManagers.computeIfAbsent((Tuple2<ResourceProfile, ResourceProfile>)Tuple2.of((Object)pendingTaskManager.getTotalResourceProfile(), (Object)pendingTaskManager.getDefaultSlotResourceProfile()), ignored -> new HashSet()).add(pendingTaskManager);
    }

    @Override
    public Map<JobID, ResourceCounter> removePendingTaskManager(PendingTaskManagerId pendingTaskManagerId) {
        Preconditions.checkNotNull((Object)((Object)pendingTaskManagerId));
        PendingTaskManager pendingTaskManager = (PendingTaskManager)Preconditions.checkNotNull((Object)this.pendingTaskManagers.remove((Object)pendingTaskManagerId));
        this.totalPendingResource = this.totalPendingResource.subtract(pendingTaskManager.getTotalResourceProfile());
        LOG.debug("Remove pending task manager {}.", (Object)pendingTaskManagerId);
        this.totalAndDefaultSlotProfilesToPendingTaskManagers.compute((Tuple2<ResourceProfile, ResourceProfile>)Tuple2.of((Object)pendingTaskManager.getTotalResourceProfile(), (Object)pendingTaskManager.getDefaultSlotResourceProfile()), (ignored, pendingTMSet) -> {
            ((Set)Preconditions.checkNotNull((Object)pendingTMSet)).remove(pendingTaskManager);
            return pendingTMSet.isEmpty() ? null : pendingTMSet;
        });
        return pendingTaskManager.getPendingSlotAllocationRecords();
    }

    @Override
    public Collection<TaskManagerInfo> getTaskManagersWithAllocatedSlotsForJob(JobID jobId) {
        return this.taskManagerRegistrations.values().stream().filter(taskManager -> taskManager.getAllocatedSlots().values().stream().anyMatch(slot -> jobId.equals((Object)slot.getJobId()))).collect(Collectors.toList());
    }

    @Override
    public void notifySlotStatus(AllocationID allocationId, JobID jobId, InstanceID instanceId, ResourceProfile resourceProfile, SlotState slotState) {
        Preconditions.checkNotNull((Object)((Object)allocationId));
        Preconditions.checkNotNull((Object)jobId);
        Preconditions.checkNotNull((Object)((Object)instanceId));
        Preconditions.checkNotNull((Object)resourceProfile);
        Preconditions.checkNotNull((Object)((Object)slotState));
        switch (slotState) {
            case FREE: {
                this.freeSlot(instanceId, allocationId);
                break;
            }
            case ALLOCATED: {
                this.addAllocatedSlot(allocationId, jobId, instanceId, resourceProfile);
                break;
            }
            case PENDING: {
                this.addPendingSlot(allocationId, jobId, instanceId, resourceProfile);
            }
        }
    }

    private void freeSlot(InstanceID instanceId, AllocationID allocationId) {
        FineGrainedTaskManagerRegistration taskManager = (FineGrainedTaskManagerRegistration)Preconditions.checkNotNull((Object)this.taskManagerRegistrations.get((Object)instanceId));
        Preconditions.checkNotNull((Object)this.slots.remove((Object)allocationId));
        LOG.debug("Free allocated slot with allocationId {}.", (Object)allocationId);
        taskManager.freeSlot(allocationId);
    }

    private void addAllocatedSlot(AllocationID allocationId, JobID jobId, InstanceID instanceId, ResourceProfile resourceProfile) {
        FineGrainedTaskManagerRegistration taskManager = (FineGrainedTaskManagerRegistration)Preconditions.checkNotNull((Object)this.taskManagerRegistrations.get((Object)instanceId));
        if (this.slots.containsKey((Object)allocationId)) {
            LOG.debug("Complete slot allocation with allocationId {}.", (Object)allocationId);
            taskManager.notifyAllocationComplete(allocationId);
        } else {
            LOG.debug("Register new allocated slot with allocationId {}.", (Object)allocationId);
            FineGrainedTaskManagerSlot slot = new FineGrainedTaskManagerSlot(allocationId, jobId, resourceProfile, taskManager.getTaskExecutorConnection(), SlotState.ALLOCATED);
            this.slots.put(allocationId, slot);
            taskManager.notifyAllocation(allocationId, slot);
        }
    }

    private void addPendingSlot(AllocationID allocationId, JobID jobId, InstanceID instanceId, ResourceProfile resourceProfile) {
        Preconditions.checkState((!this.slots.containsKey((Object)allocationId) ? 1 : 0) != 0);
        FineGrainedTaskManagerRegistration taskManager = (FineGrainedTaskManagerRegistration)Preconditions.checkNotNull((Object)this.taskManagerRegistrations.get((Object)instanceId));
        LOG.debug("Add pending slot with allocationId {}.", (Object)allocationId);
        FineGrainedTaskManagerSlot slot = new FineGrainedTaskManagerSlot(allocationId, jobId, resourceProfile, taskManager.getTaskExecutorConnection(), SlotState.PENDING);
        taskManager.notifyAllocation(allocationId, slot);
        this.slots.put(allocationId, slot);
    }

    @Override
    public Collection<? extends TaskManagerInfo> getRegisteredTaskManagers() {
        return Collections.unmodifiableCollection(this.taskManagerRegistrations.values());
    }

    @Override
    public Optional<TaskManagerInfo> getRegisteredTaskManager(InstanceID instanceId) {
        return Optional.ofNullable((TaskManagerInfo)this.taskManagerRegistrations.get((Object)instanceId));
    }

    @Override
    public Optional<TaskManagerSlotInformation> getAllocatedOrPendingSlot(AllocationID allocationId) {
        return Optional.ofNullable((TaskManagerSlotInformation)this.slots.get((Object)allocationId));
    }

    @Override
    public Collection<PendingTaskManager> getPendingTaskManagers() {
        return Collections.unmodifiableCollection(this.pendingTaskManagers.values());
    }

    @Override
    public Collection<PendingTaskManager> getPendingTaskManagersByTotalAndDefaultSlotResourceProfile(ResourceProfile totalResourceProfile, ResourceProfile defaultSlotResourceProfile) {
        return Collections.unmodifiableCollection(this.totalAndDefaultSlotProfilesToPendingTaskManagers.getOrDefault(Tuple2.of((Object)totalResourceProfile, (Object)defaultSlotResourceProfile), Collections.emptySet()));
    }

    @Override
    public int getNumberRegisteredSlots() {
        return this.taskManagerRegistrations.values().stream().mapToInt(TaskManagerInfo::getDefaultNumSlots).sum();
    }

    @Override
    public int getNumberRegisteredSlotsOf(InstanceID instanceId) {
        return Optional.ofNullable(this.taskManagerRegistrations.get((Object)instanceId)).map(TaskManagerInfo::getDefaultNumSlots).orElse(0);
    }

    @Override
    public int getNumberFreeSlots() {
        return this.taskManagerRegistrations.keySet().stream().mapToInt(this::getNumberFreeSlotsOf).sum();
    }

    @Override
    public int getNumberFreeSlotsOf(InstanceID instanceId) {
        return Optional.ofNullable(this.taskManagerRegistrations.get((Object)instanceId)).map(taskManager -> Math.max(taskManager.getDefaultNumSlots() - taskManager.getAllocatedSlots().size(), 0)).orElse(0);
    }

    @Override
    public ResourceProfile getRegisteredResource() {
        return this.totalRegisteredResource;
    }

    @Override
    public ResourceProfile getRegisteredResourceOf(InstanceID instanceId) {
        return Optional.ofNullable(this.taskManagerRegistrations.get((Object)instanceId)).map(TaskManagerInfo::getTotalResource).orElse(ResourceProfile.ZERO);
    }

    @Override
    public ResourceProfile getFreeResource() {
        return this.taskManagerRegistrations.values().stream().map(TaskManagerInfo::getAvailableResource).reduce(ResourceProfile.ZERO, ResourceProfile::merge);
    }

    @Override
    public ResourceProfile getFreeResourceOf(InstanceID instanceId) {
        return Optional.ofNullable(this.taskManagerRegistrations.get((Object)instanceId)).map(TaskManagerInfo::getAvailableResource).orElse(ResourceProfile.ZERO);
    }

    @Override
    public ResourceProfile getPendingResource() {
        return this.totalPendingResource;
    }

    @Override
    public void clear() {
        this.slots.clear();
        this.taskManagerRegistrations.clear();
        this.totalRegisteredResource = ResourceProfile.ZERO;
        this.pendingTaskManagers.clear();
        this.totalPendingResource = ResourceProfile.ZERO;
        this.unWantedTaskManagers.clear();
    }
}

