/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.registration;

import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TaskExecutorMemoryConfiguration;
import org.apache.flink.util.Preconditions;

public class WorkerRegistration<WorkerType extends ResourceIDRetrievable>
extends TaskExecutorConnection {
    private final WorkerType worker;
    private final int dataPort;
    private final int jmxPort;
    private final HardwareDescription hardwareDescription;
    private final TaskExecutorMemoryConfiguration memoryConfiguration;
    private final ResourceProfile totalResourceProfile;
    private final ResourceProfile defaultSlotResourceProfile;
    private final String nodeId;

    public WorkerRegistration(TaskExecutorGateway taskExecutorGateway, WorkerType worker, int dataPort, int jmxPort, HardwareDescription hardwareDescription, TaskExecutorMemoryConfiguration memoryConfiguration, ResourceProfile totalResourceProfile, ResourceProfile defaultSlotResourceProfile, String nodeId) {
        super(worker.getResourceID(), taskExecutorGateway);
        this.worker = (ResourceIDRetrievable)Preconditions.checkNotNull(worker);
        this.dataPort = dataPort;
        this.jmxPort = jmxPort;
        this.hardwareDescription = (HardwareDescription)Preconditions.checkNotNull((Object)hardwareDescription);
        this.memoryConfiguration = (TaskExecutorMemoryConfiguration)Preconditions.checkNotNull((Object)memoryConfiguration);
        this.totalResourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)totalResourceProfile);
        this.defaultSlotResourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)defaultSlotResourceProfile);
        this.nodeId = (String)Preconditions.checkNotNull((Object)nodeId);
    }

    public WorkerType getWorker() {
        return this.worker;
    }

    public int getDataPort() {
        return this.dataPort;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public HardwareDescription getHardwareDescription() {
        return this.hardwareDescription;
    }

    public TaskExecutorMemoryConfiguration getMemoryConfiguration() {
        return this.memoryConfiguration;
    }

    public ResourceProfile getDefaultSlotResourceProfile() {
        return this.defaultSlotResourceProfile;
    }

    public ResourceProfile getTotalResourceProfile() {
        return this.totalResourceProfile;
    }

    public String getNodeId() {
        return this.nodeId;
    }
}

