/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blocklist.BlocklistListener;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.io.network.partition.ClusterPartitionManager;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.ResourceOverview;
import org.apache.flink.runtime.resourcemanager.TaskExecutorRegistration;
import org.apache.flink.runtime.resourcemanager.TaskManagerInfoWithSlots;
import org.apache.flink.runtime.rest.messages.LogInfo;
import org.apache.flink.runtime.rest.messages.ProfilingInfo;
import org.apache.flink.runtime.rest.messages.ThreadDumpInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerInfo;
import org.apache.flink.runtime.rpc.FencedRpcGateway;
import org.apache.flink.runtime.rpc.RpcTimeout;
import org.apache.flink.runtime.slots.ResourceRequirements;
import org.apache.flink.runtime.taskexecutor.FileType;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.TaskExecutorHeartbeatPayload;
import org.apache.flink.runtime.taskexecutor.TaskExecutorThreadInfoGateway;

public interface ResourceManagerGateway
extends FencedRpcGateway<ResourceManagerId>,
ClusterPartitionManager,
BlocklistListener {
    public CompletableFuture<RegistrationResponse> registerJobMaster(JobMasterId var1, ResourceID var2, String var3, JobID var4, @RpcTimeout Duration var5);

    public CompletableFuture<Acknowledge> declareRequiredResources(JobMasterId var1, ResourceRequirements var2, @RpcTimeout Duration var3);

    public CompletableFuture<RegistrationResponse> registerTaskExecutor(TaskExecutorRegistration var1, @RpcTimeout Duration var2);

    public CompletableFuture<Acknowledge> sendSlotReport(ResourceID var1, InstanceID var2, SlotReport var3, @RpcTimeout Duration var4);

    public void notifySlotAvailable(InstanceID var1, SlotID var2, AllocationID var3);

    public CompletableFuture<Acknowledge> deregisterApplication(ApplicationStatus var1, @Nullable String var2);

    public CompletableFuture<Integer> getNumberOfRegisteredTaskManagers();

    public CompletableFuture<Void> heartbeatFromTaskManager(ResourceID var1, TaskExecutorHeartbeatPayload var2);

    public CompletableFuture<Void> heartbeatFromJobManager(ResourceID var1);

    public void disconnectTaskManager(ResourceID var1, Exception var2);

    public void disconnectJobManager(JobID var1, JobStatus var2, Exception var3);

    public CompletableFuture<Collection<TaskManagerInfo>> requestTaskManagerInfo(@RpcTimeout Duration var1);

    public CompletableFuture<TaskManagerInfoWithSlots> requestTaskManagerDetailsInfo(ResourceID var1, @RpcTimeout Duration var2);

    public CompletableFuture<ResourceOverview> requestResourceOverview(@RpcTimeout Duration var1);

    public CompletableFuture<Collection<Tuple2<ResourceID, String>>> requestTaskManagerMetricQueryServiceAddresses(@RpcTimeout Duration var1);

    public CompletableFuture<TransientBlobKey> requestTaskManagerFileUploadByType(ResourceID var1, FileType var2, @RpcTimeout Duration var3);

    public CompletableFuture<TransientBlobKey> requestTaskManagerFileUploadByNameAndType(ResourceID var1, String var2, FileType var3, @RpcTimeout Duration var4);

    public CompletableFuture<Collection<LogInfo>> requestTaskManagerLogList(ResourceID var1, @RpcTimeout Duration var2);

    public CompletableFuture<ThreadDumpInfo> requestThreadDump(ResourceID var1, @RpcTimeout Duration var2);

    public CompletableFuture<TaskExecutorThreadInfoGateway> requestTaskExecutorThreadInfoGateway(ResourceID var1, @RpcTimeout Duration var2);

    public CompletableFuture<Collection<ProfilingInfo>> requestTaskManagerProfilingList(ResourceID var1, @RpcTimeout Duration var2);

    public CompletableFuture<ProfilingInfo> requestProfiling(ResourceID var1, int var2, ProfilingInfo.ProfilingMode var3, @RpcTimeout Duration var4);
}

