/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.runtime.operators.hash.InPlaceMutableHashTable;
import org.apache.flink.runtime.operators.sort.FixedLengthRecordSorter;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.runtime.operators.sort.NormalizedKeySorter;
import org.apache.flink.runtime.operators.sort.QuickSort;
import org.apache.flink.runtime.operators.util.metrics.CountingCollector;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReduceCombineDriver<T>
implements Driver<ReduceFunction<T>, T> {
    private static final Logger LOG = LoggerFactory.getLogger(ReduceCombineDriver.class);
    private static final int THRESHOLD_FOR_IN_PLACE_SORTING = 32;
    private TaskContext<ReduceFunction<T>, T> taskContext;
    private TypeSerializer<T> serializer;
    private TypeComparator<T> comparator;
    private ReduceFunction<T> reducer;
    private Collector<T> output;
    private DriverStrategy strategy;
    private InMemorySorter<T> sorter;
    private QuickSort sortAlgo = new QuickSort();
    private InPlaceMutableHashTable<T> table;
    private InPlaceMutableHashTable.ReduceFacade reduceFacade;
    private List<MemorySegment> memory;
    private volatile boolean running;
    private boolean objectReuseEnabled = false;

    @Override
    public void setup(TaskContext<ReduceFunction<T>, T> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<ReduceFunction<T>> getStubType() {
        Class<ReduceFunction> clazz = ReduceFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 1;
    }

    @Override
    public void prepare() throws Exception {
        Counter numRecordsOut = this.taskContext.getMetricGroup().getIOMetricGroup().getNumRecordsOutCounter();
        this.strategy = this.taskContext.getTaskConfig().getDriverStrategy();
        TypeSerializerFactory serializerFactory = this.taskContext.getInputSerializer(0);
        this.comparator = this.taskContext.getDriverComparator(0);
        this.serializer = serializerFactory.getSerializer();
        this.reducer = this.taskContext.getStub();
        this.output = new CountingCollector<T>(this.taskContext.getOutputCollector(), numRecordsOut);
        MemoryManager memManager = this.taskContext.getMemoryManager();
        int numMemoryPages = memManager.computeNumberOfPages(this.taskContext.getTaskConfig().getRelativeMemoryDriver());
        this.memory = memManager.allocatePages(this.taskContext.getContainingTask(), numMemoryPages);
        ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
        this.objectReuseEnabled = executionConfig.isObjectReuseEnabled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("ReduceCombineDriver object reuse: " + (this.objectReuseEnabled ? "ENABLED" : "DISABLED") + ".");
        }
        switch (this.strategy) {
            case SORTED_PARTIAL_REDUCE: {
                if (this.comparator.supportsSerializationWithKeyNormalization() && this.serializer.getLength() > 0 && this.serializer.getLength() <= 32) {
                    this.sorter = new FixedLengthRecordSorter<T>(this.serializer, this.comparator.duplicate(), this.memory);
                    break;
                }
                this.sorter = new NormalizedKeySorter<T>(this.serializer, this.comparator.duplicate(), this.memory);
                break;
            }
            case HASHED_PARTIAL_REDUCE: {
                InPlaceMutableHashTable<T> inPlaceMutableHashTable = this.table = new InPlaceMutableHashTable<T>(this.serializer, this.comparator, this.memory);
                Objects.requireNonNull(inPlaceMutableHashTable);
                this.reduceFacade = new InPlaceMutableHashTable.ReduceFacade(inPlaceMutableHashTable, this.reducer, this.output, this.objectReuseEnabled);
                break;
            }
            default: {
                throw new Exception("Invalid strategy " + this.taskContext.getTaskConfig().getDriverStrategy() + " for reduce combiner.");
            }
        }
    }

    @Override
    public void run() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Combiner starting.");
        }
        Counter numRecordsIn = this.taskContext.getMetricGroup().getIOMetricGroup().getNumRecordsInCounter();
        MutableObjectIterator in = this.taskContext.getInput(0);
        TypeSerializer<T> serializer = this.serializer;
        switch (this.strategy) {
            case SORTED_PARTIAL_REDUCE: {
                if (this.objectReuseEnabled) {
                    Object value = serializer.createInstance();
                    while (this.running && (value = in.next(value)) != null) {
                        numRecordsIn.inc();
                        if (this.sorter.write(value)) continue;
                        this.sortAndCombine();
                        this.sorter.reset();
                        if (this.sorter.write(value)) continue;
                        throw new IOException("Cannot write record to fresh sort buffer. Record too large.");
                    }
                } else {
                    Object value;
                    while (this.running && (value = in.next()) != null) {
                        numRecordsIn.inc();
                        if (this.sorter.write(value)) continue;
                        this.sortAndCombine();
                        this.sorter.reset();
                        if (this.sorter.write(value)) continue;
                        throw new IOException("Cannot write record to fresh sort buffer. Record too large.");
                    }
                }
                this.sortAndCombine();
                break;
            }
            case HASHED_PARTIAL_REDUCE: {
                this.table.open();
                if (this.objectReuseEnabled) {
                    Object value = serializer.createInstance();
                    while (this.running && (value = in.next(value)) != null) {
                        numRecordsIn.inc();
                        try {
                            this.reduceFacade.updateTableEntryWithReduce(value);
                        }
                        catch (EOFException ex) {
                            this.reduceFacade.emitAndReset();
                            this.reduceFacade.updateTableEntryWithReduce(value);
                        }
                    }
                } else {
                    Object value;
                    while (this.running && (value = in.next()) != null) {
                        numRecordsIn.inc();
                        try {
                            this.reduceFacade.updateTableEntryWithReduce(value);
                        }
                        catch (EOFException ex) {
                            this.reduceFacade.emitAndReset();
                            this.reduceFacade.updateTableEntryWithReduce(value);
                        }
                    }
                }
                this.reduceFacade.emit();
                this.table.close();
                break;
            }
            default: {
                throw new Exception("Invalid strategy " + this.taskContext.getTaskConfig().getDriverStrategy() + " for reduce combiner.");
            }
        }
    }

    private void sortAndCombine() throws Exception {
        block6: {
            InMemorySorter<T> sorter = this.sorter;
            if (sorter.isEmpty()) break block6;
            this.sortAlgo.sort(sorter);
            TypeSerializer<T> serializer = this.serializer;
            TypeComparator<T> comparator = this.comparator;
            ReduceFunction<T> function = this.reducer;
            Collector<T> output = this.output;
            MutableObjectIterator<T> input = sorter.getIterator();
            if (this.objectReuseEnabled) {
                Object reuse1 = input.next();
                Object reuse2 = serializer.createInstance();
                Object value = reuse1;
                while (this.running && value != null) {
                    Object tmp;
                    comparator.setReference(value);
                    while ((reuse2 = input.next(reuse2)) != null && comparator.equalToReference(reuse2)) {
                        if ((value = function.reduce(value, reuse2)) != reuse2) continue;
                        tmp = reuse1;
                        reuse1 = reuse2;
                        reuse2 = tmp;
                    }
                    output.collect(value);
                    tmp = reuse1;
                    reuse1 = reuse2;
                    reuse2 = tmp;
                    value = reuse1;
                }
            } else {
                Object value = input.next();
                while (this.running && value != null) {
                    comparator.setReference(value);
                    Object res = value;
                    while ((value = input.next()) != null && comparator.equalToReference(value)) {
                        res = function.reduce(res, value);
                    }
                    output.collect(res);
                }
            }
        }
    }

    @Override
    public void cleanup() {
        try {
            if (this.sorter != null) {
                this.sorter.dispose();
            }
            if (this.table != null) {
                this.table.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.taskContext.getMemoryManager().release(this.memory);
    }

    @Override
    public void cancel() {
        this.running = false;
        this.cleanup();
    }
}

