/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.runtime.metrics.filter.ReporterFilter;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReporterSetup<REPORTER, REPORTED> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractReporterSetup.class);
    protected final String name;
    protected final MetricConfig configuration;
    protected final REPORTER reporter;
    protected final ReporterFilter<REPORTED> filter;
    protected final Map<String, String> additionalVariables;

    public AbstractReporterSetup(String name, MetricConfig configuration, REPORTER reporter, ReporterFilter<REPORTED> filter, Map<String, String> additionalVariables) {
        this.name = name;
        this.configuration = configuration;
        this.reporter = reporter;
        this.filter = filter;
        this.additionalVariables = additionalVariables;
    }

    public Map<String, String> getAdditionalVariables() {
        return this.additionalVariables;
    }

    public String getName() {
        return this.name;
    }

    @VisibleForTesting
    MetricConfig getConfiguration() {
        return this.configuration;
    }

    public REPORTER getReporter() {
        return this.reporter;
    }

    public ReporterFilter<REPORTED> getFilter() {
        return this.filter;
    }

    public Optional<String> getDelimiter() {
        return Optional.ofNullable(this.configuration.getString(this.getDelimiterConfigOption().key(), null));
    }

    public Set<String> getExcludedVariables() {
        String excludedVariablesList = this.configuration.getString(this.getExcludedVariablesConfigOption().key(), null);
        if (excludedVariablesList == null) {
            return Collections.emptySet();
        }
        HashSet<String> excludedVariables = new HashSet<String>();
        for (String exclusion : excludedVariablesList.split(";")) {
            excludedVariables.add(ScopeFormat.asVariable(exclusion));
        }
        return Collections.unmodifiableSet(excludedVariables);
    }

    protected abstract ConfigOption<String> getDelimiterConfigOption();

    protected abstract ConfigOption<String> getExcludedVariablesConfigOption();
}

