/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import org.apache.flink.runtime.io.network.partition.DeduplicatedQueue;
import org.apache.flink.runtime.io.network.partition.SubpartitionSelector;

public class RoundRobinSubpartitionSelector<T>
implements SubpartitionSelector<T> {
    private final DeduplicatedQueue<T> subpartitions = new DeduplicatedQueue();
    private T lastReturnedSubpartition = null;
    private boolean isLastBufferPartialRecord = false;

    @Override
    public boolean notifyDataAvailable(T subpartition) {
        return this.subpartitions.add(subpartition);
    }

    @Override
    public T getNextSubpartitionToConsume() {
        if (this.isLastBufferPartialRecord) {
            return this.lastReturnedSubpartition;
        }
        if (this.subpartitions.isEmpty()) {
            return null;
        }
        T subpartitionIndex = this.subpartitions.poll();
        if (this.lastReturnedSubpartition != null && this.lastReturnedSubpartition.equals(subpartitionIndex)) {
            this.subpartitions.add(subpartitionIndex);
            subpartitionIndex = this.subpartitions.poll();
        }
        this.lastReturnedSubpartition = subpartitionIndex;
        return subpartitionIndex;
    }

    @Override
    public void markLastConsumptionStatus(boolean isDataAvailable, boolean isPartialRecord) {
        if (isDataAvailable) {
            this.subpartitions.add(this.lastReturnedSubpartition);
            this.isLastBufferPartialRecord = isPartialRecord;
        } else {
            this.subpartitions.remove(this.lastReturnedSubpartition);
        }
    }

    @Override
    public boolean isMoreSubpartitionSwitchable() {
        return !this.isLastBufferPartialRecord && !this.subpartitions.isEmpty();
    }
}

