/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.metrics;

import org.apache.flink.runtime.io.network.metrics.AbstractBuffersUsageGauge;
import org.apache.flink.runtime.io.network.metrics.ExclusiveBuffersUsageGauge;
import org.apache.flink.runtime.io.network.metrics.FloatingBuffersUsageGauge;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.util.Preconditions;

public class CreditBasedInputBuffersUsageGauge
extends AbstractBuffersUsageGauge {
    private final FloatingBuffersUsageGauge floatingBuffersUsageGauge;
    private final ExclusiveBuffersUsageGauge exclusiveBuffersUsageGauge;

    public CreditBasedInputBuffersUsageGauge(FloatingBuffersUsageGauge floatingBuffersUsageGauge, ExclusiveBuffersUsageGauge exclusiveBuffersUsageGauge, SingleInputGate[] inputGates) {
        super((SingleInputGate[])Preconditions.checkNotNull((Object)inputGates));
        this.floatingBuffersUsageGauge = (FloatingBuffersUsageGauge)Preconditions.checkNotNull((Object)floatingBuffersUsageGauge);
        this.exclusiveBuffersUsageGauge = (ExclusiveBuffersUsageGauge)Preconditions.checkNotNull((Object)exclusiveBuffersUsageGauge);
    }

    @Override
    public int calculateUsedBuffers(SingleInputGate inputGate) {
        return this.floatingBuffersUsageGauge.calculateUsedBuffers(inputGate) + this.exclusiveBuffersUsageGauge.calculateUsedBuffers(inputGate);
    }

    @Override
    public int calculateTotalBuffers(SingleInputGate inputGate) {
        return this.floatingBuffersUsageGauge.calculateTotalBuffers(inputGate) + this.exclusiveBuffersUsageGauge.calculateTotalBuffers(inputGate);
    }
}

