/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.AbstractCompositeBuffer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferHeader;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.CompositeByteBuf;
import org.apache.flink.util.Preconditions;

public class CompositeBuffer
extends AbstractCompositeBuffer {
    public CompositeBuffer(Buffer.DataType dataType, int length, boolean isCompressed) {
        super(dataType, length, isCompressed);
    }

    public CompositeBuffer(BufferHeader header) {
        this(header.getDataType(), header.getLength(), header.isCompressed());
    }

    @Override
    public ByteBuf asByteBuf() {
        CompositeByteBuf compositeByteBuf = ((ByteBufAllocator)Preconditions.checkNotNull((Object)this.allocator)).compositeDirectBuffer();
        for (Buffer buffer : this.partialBuffers) {
            compositeByteBuf.addComponent(buffer.asByteBuf());
        }
        compositeByteBuf.writerIndex(this.currentLength);
        return compositeByteBuf;
    }

    public Buffer getFullBufferData(MemorySegment segment) {
        Preconditions.checkState((!this.partialBuffers.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.currentLength <= segment.size() ? 1 : 0) != 0);
        if (this.partialBuffers.size() == 1) {
            return (Buffer)this.partialBuffers.get(0);
        }
        int offset = 0;
        for (Buffer buffer : this.partialBuffers) {
            segment.put(offset, buffer.getNioBufferReadable(), buffer.readableBytes());
            offset += buffer.readableBytes();
        }
        this.recycleBuffer();
        return new NetworkBuffer(segment, BufferRecycler.DummyBufferRecycler.INSTANCE, this.dataType, this.isCompressed, this.currentLength);
    }

    @Override
    public void addPartialBuffer(Buffer buffer) {
        buffer.setDataType(this.dataType);
        buffer.setCompressed(this.isCompressed);
        this.partialBuffers.add(buffer);
        this.currentLength += buffer.readableBytes();
        Preconditions.checkState((this.currentLength <= this.length ? 1 : 0) != 0);
    }
}

