/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.deployment.ConsumedSubpartitionContext;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.util.GroupCache;
import org.apache.flink.util.CompressedSerializedValue;
import org.apache.flink.util.Preconditions;

public class InputGateDeploymentDescriptor
implements Serializable {
    private static final long serialVersionUID = -7143441863165366704L;
    private final IntermediateDataSetID consumedResultId;
    private final ResultPartitionType consumedPartitionType;
    private final ConsumedSubpartitionContext consumedSubpartitionContext;
    private transient ShuffleDescriptor[] inputChannels;
    private final List<TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup>> serializedInputChannels;
    private final int numberOfInputChannels;

    @VisibleForTesting
    public InputGateDeploymentDescriptor(IntermediateDataSetID consumedResultId, ResultPartitionType consumedPartitionType, @Nonnegative int consumedSubpartitionIndex, TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[] inputChannels) throws IOException {
        this(consumedResultId, consumedPartitionType, new IndexRange(consumedSubpartitionIndex, consumedSubpartitionIndex), inputChannels.length, Collections.singletonList(new TaskDeploymentDescriptor.NonOffloaded(CompressedSerializedValue.fromObject((Object)new TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup(inputChannels)))));
    }

    public InputGateDeploymentDescriptor(IntermediateDataSetID consumedResultId, ResultPartitionType consumedPartitionType, IndexRange consumedSubpartitionIndexRange, int numberOfInputChannels, List<TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup>> serializedInputChannels) {
        this(consumedResultId, consumedPartitionType, ConsumedSubpartitionContext.buildConsumedSubpartitionContext(numberOfInputChannels, consumedSubpartitionIndexRange), numberOfInputChannels, serializedInputChannels);
    }

    public InputGateDeploymentDescriptor(IntermediateDataSetID consumedResultId, ResultPartitionType consumedPartitionType, ConsumedSubpartitionContext consumedSubpartitionContext, int numberOfInputChannels, List<TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup>> serializedInputChannels) {
        this.consumedResultId = (IntermediateDataSetID)Preconditions.checkNotNull((Object)consumedResultId);
        this.consumedPartitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)consumedPartitionType)));
        this.consumedSubpartitionContext = (ConsumedSubpartitionContext)Preconditions.checkNotNull((Object)consumedSubpartitionContext);
        this.serializedInputChannels = (List)Preconditions.checkNotNull(serializedInputChannels);
        this.numberOfInputChannels = numberOfInputChannels;
    }

    public IntermediateDataSetID getConsumedResultId() {
        return this.consumedResultId;
    }

    public ResultPartitionType getConsumedPartitionType() {
        return this.consumedPartitionType;
    }

    public int getNumConsumedShuffleDescriptors() {
        return this.consumedSubpartitionContext.getNumConsumedShuffleDescriptors();
    }

    public Collection<IndexRange> getConsumedShuffleDescriptorRanges() {
        return this.consumedSubpartitionContext.getConsumedShuffleDescriptorRanges();
    }

    public IndexRange getConsumedSubpartitionRange(int shuffleDescriptorIndex) {
        return this.consumedSubpartitionContext.getConsumedSubpartitionRange(shuffleDescriptorIndex);
    }

    public ShuffleDescriptor[] getShuffleDescriptors() {
        if (this.inputChannels == null) {
            this.inputChannels = new ShuffleDescriptor[this.numberOfInputChannels];
            try {
                for (TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup> serializedShuffleDescriptors : this.serializedInputChannels) {
                    Preconditions.checkState((boolean)(serializedShuffleDescriptors instanceof TaskDeploymentDescriptor.NonOffloaded), (Object)"Trying to work with offloaded serialized shuffle descriptors.");
                    TaskDeploymentDescriptor.NonOffloaded nonOffloadedSerializedValue = (TaskDeploymentDescriptor.NonOffloaded)serializedShuffleDescriptors;
                    this.tryDeserializeShuffleDescriptorGroup(nonOffloadedSerializedValue);
                }
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException("Could not deserialize shuffle descriptors.", e);
            }
        }
        return this.inputChannels;
    }

    public void tryLoadAndDeserializeShuffleDescriptors(@Nullable PermanentBlobService blobService, JobID jobId, GroupCache<JobID, PermanentBlobKey, TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup> shuffleDescriptorsCache) throws IOException {
        if (this.inputChannels != null) {
            return;
        }
        try {
            this.inputChannels = new ShuffleDescriptor[this.numberOfInputChannels];
            for (TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup> serializedShuffleDescriptors : this.serializedInputChannels) {
                this.tryLoadAndDeserializeShuffleDescriptorGroup(blobService, jobId, serializedShuffleDescriptors, shuffleDescriptorsCache);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not deserialize shuffle descriptors.", e);
        }
    }

    private void tryLoadAndDeserializeShuffleDescriptorGroup(@Nullable PermanentBlobService blobService, JobID jobId, TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup> serializedShuffleDescriptors, GroupCache<JobID, PermanentBlobKey, TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup> shuffleDescriptorsCache) throws IOException, ClassNotFoundException {
        if (serializedShuffleDescriptors instanceof TaskDeploymentDescriptor.Offloaded) {
            PermanentBlobKey blobKey = ((TaskDeploymentDescriptor.Offloaded)serializedShuffleDescriptors).serializedValueKey;
            TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup shuffleDescriptorGroup = shuffleDescriptorsCache.get(jobId, blobKey);
            if (shuffleDescriptorGroup == null) {
                Preconditions.checkNotNull((Object)blobService);
                CompressedSerializedValue serializedValue = CompressedSerializedValue.fromBytes((byte[])blobService.readFile(jobId, blobKey));
                shuffleDescriptorGroup = (TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup)serializedValue.deserializeValue(this.getClass().getClassLoader());
                shuffleDescriptorsCache.put(jobId, blobKey, shuffleDescriptorGroup);
            }
            this.putOrReplaceShuffleDescriptors(shuffleDescriptorGroup);
        } else {
            TaskDeploymentDescriptor.NonOffloaded nonOffloadedSerializedValue = (TaskDeploymentDescriptor.NonOffloaded)serializedShuffleDescriptors;
            this.tryDeserializeShuffleDescriptorGroup(nonOffloadedSerializedValue);
        }
    }

    private void tryDeserializeShuffleDescriptorGroup(TaskDeploymentDescriptor.NonOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup> nonOffloadedShuffleDescriptorGroup) throws IOException, ClassNotFoundException {
        TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup shuffleDescriptorGroup = (TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup)nonOffloadedShuffleDescriptorGroup.serializedValue.deserializeValue(this.getClass().getClassLoader());
        this.putOrReplaceShuffleDescriptors(shuffleDescriptorGroup);
    }

    private void putOrReplaceShuffleDescriptors(TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup shuffleDescriptorGroup) {
        for (TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex shuffleDescriptorAndIndex : shuffleDescriptorGroup.getShuffleDescriptors()) {
            ShuffleDescriptor inputChannelDescriptor = this.inputChannels[shuffleDescriptorAndIndex.getIndex()];
            if (inputChannelDescriptor != null) {
                Preconditions.checkState((boolean)inputChannelDescriptor.isUnknown(), (Object)"Only unknown shuffle descriptor can be replaced.");
            }
            this.inputChannels[shuffleDescriptorAndIndex.getIndex()] = shuffleDescriptorAndIndex.getShuffleDescriptor();
        }
    }

    public String toString() {
        return String.format("InputGateDeploymentDescriptor [result id: %s, consumed subpartition context: %s]", this.consumedResultId.toString(), this.consumedSubpartitionContext.toString());
    }
}

