/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing.operators.windowing.triggers;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.triggers.AsyncTrigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.Window;

@Experimental
public class AsyncPurgingTrigger<T, W extends Window>
extends AsyncTrigger<T, W> {
    private static final long serialVersionUID = 1L;
    private AsyncTrigger<T, W> nestedTrigger;

    private AsyncPurgingTrigger(AsyncTrigger<T, W> nestedTrigger) {
        this.nestedTrigger = nestedTrigger;
    }

    @Override
    public StateFuture<TriggerResult> onElement(T element, long timestamp, W window, AsyncTrigger.TriggerContext ctx) throws Exception {
        return this.nestedTrigger.onElement(element, timestamp, window, ctx).thenApply(triggerResult -> triggerResult.isFire() ? TriggerResult.FIRE_AND_PURGE : triggerResult);
    }

    @Override
    public StateFuture<TriggerResult> onEventTime(long time, W window, AsyncTrigger.TriggerContext ctx) throws Exception {
        return this.nestedTrigger.onEventTime(time, window, ctx).thenApply(triggerResult -> triggerResult.isFire() ? TriggerResult.FIRE_AND_PURGE : triggerResult);
    }

    @Override
    public StateFuture<TriggerResult> onProcessingTime(long time, W window, AsyncTrigger.TriggerContext ctx) throws Exception {
        return this.nestedTrigger.onProcessingTime(time, window, ctx).thenApply(triggerResult -> triggerResult.isFire() ? TriggerResult.FIRE_AND_PURGE : triggerResult);
    }

    @Override
    public StateFuture<Void> clear(W window, AsyncTrigger.TriggerContext ctx) throws Exception {
        return this.nestedTrigger.clear(window, ctx);
    }

    @Override
    public boolean canMerge() {
        return this.nestedTrigger.canMerge();
    }

    @Override
    public void onMerge(W window, AsyncTrigger.OnMergeContext ctx) throws Exception {
        this.nestedTrigger.onMerge(window, ctx);
    }

    public String toString() {
        return "PurgingTrigger(" + this.nestedTrigger.toString() + ")";
    }

    public static <T, W extends Window> AsyncPurgingTrigger<T, W> of(AsyncTrigger<T, W> nestedTrigger) {
        return new AsyncPurgingTrigger<T, W>(nestedTrigger);
    }

    @VisibleForTesting
    public AsyncTrigger<T, W> getNestedTrigger() {
        return this.nestedTrigger;
    }
}

