/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.watermarkstatus;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.streaming.runtime.watermarkstatus.HeapPriorityQueue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class HeapPriorityQueueTest {
    private static final HeapPriorityQueue.PriorityComparator<TestElement> TEST_ELEMENT_PRIORITY_COMPARATOR = (left, right) -> Long.compare(left.getPriority(), right.getPriority());

    HeapPriorityQueueTest() {
    }

    @Test
    void testPeekPollOrder() {
        TestElement testElement;
        int initialCapacity = 4;
        int testSize = 1000;
        Comparator<Long> comparator = this.getTestElementPriorityComparator();
        HeapPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(4);
        HashSet<TestElement> checkSet = new HashSet<TestElement>(1000);
        HeapPriorityQueueTest.insertRandomElements(priorityQueue, checkSet, 1000);
        long lastPriorityValue = this.getHighestPriorityValueForComparator();
        int lastSize = priorityQueue.size();
        Assertions.assertThat((int)1000).isEqualTo(lastSize);
        while ((testElement = (TestElement)priorityQueue.peek()) != null) {
            Assertions.assertThat((boolean)priorityQueue.isEmpty()).isFalse();
            Assertions.assertThat((int)lastSize).isEqualTo(priorityQueue.size());
            Assertions.assertThat((Object)testElement).isEqualTo((Object)priorityQueue.poll());
            Assertions.assertThat((boolean)checkSet.remove(testElement)).isTrue();
            Assertions.assertThat((comparator.compare(testElement.getPriority(), lastPriorityValue) >= 0 ? 1 : 0) != 0).isTrue();
            lastPriorityValue = testElement.getPriority();
            --lastSize;
        }
        Assertions.assertThat((boolean)priorityQueue.isEmpty()).isTrue();
        Assertions.assertThat((int)priorityQueue.size()).isZero();
        Assertions.assertThat(checkSet).isEmpty();
    }

    @Test
    void testRemoveInsertMixKeepsOrder() {
        HeapPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(3);
        Comparator<Long> comparator = this.getTestElementPriorityComparator();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int testSize = 300;
        int addCounterMax = 75;
        int iterationsTillNextAdds = random.nextInt(75);
        HashSet<TestElement> checkSet = new HashSet<TestElement>(300);
        HeapPriorityQueueTest.insertRandomElements(priorityQueue, checkSet, 300);
        while (!checkSet.isEmpty()) {
            long highestPrioValue = this.getHighestPriorityValueForComparator();
            Iterator<TestElement> iterator = checkSet.iterator();
            TestElement element = iterator.next();
            iterator.remove();
            boolean removesHead = element.equals(priorityQueue.peek());
            if (removesHead) {
                Assertions.assertThat((boolean)priorityQueue.remove((HeapPriorityQueue.HeapPriorityQueueElement)element)).isTrue();
            } else {
                priorityQueue.remove((HeapPriorityQueue.HeapPriorityQueueElement)element);
            }
            long currentPriorityWatermark = removesHead ? element.getPriority() : highestPrioValue;
            while ((element = (TestElement)priorityQueue.poll()) != null) {
                Assertions.assertThat((comparator.compare(element.getPriority(), currentPriorityWatermark) >= 0 ? 1 : 0) != 0).isTrue();
                currentPriorityWatermark = element.getPriority();
                if (--iterationsTillNextAdds != 0) continue;
                iterationsTillNextAdds = random.nextInt(75);
                HeapPriorityQueueTest.insertRandomElements(priorityQueue, new HashSet<TestElement>(checkSet), 1 + random.nextInt(3));
                currentPriorityWatermark = ((TestElement)priorityQueue.peek()).getPriority();
            }
            Assertions.assertThat((boolean)priorityQueue.isEmpty()).isTrue();
            checkSet.forEach(arg_0 -> priorityQueue.add(arg_0));
        }
    }

    @Test
    void testPoll() {
        HeapPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(3);
        Comparator<Long> comparator = this.getTestElementPriorityComparator();
        Assertions.assertThat((Object)((TestElement)priorityQueue.poll())).isNull();
        int testSize = 345;
        HashSet<TestElement> checkSet = new HashSet<TestElement>(345);
        HeapPriorityQueueTest.insertRandomElements(priorityQueue, checkSet, 345);
        long lastPriorityValue = this.getHighestPriorityValueForComparator();
        while (!priorityQueue.isEmpty()) {
            TestElement removed = (TestElement)priorityQueue.poll();
            Assertions.assertThat((Object)removed).isNotNull();
            Assertions.assertThat((boolean)checkSet.remove(removed)).isTrue();
            Assertions.assertThat((comparator.compare(removed.getPriority(), lastPriorityValue) >= 0 ? 1 : 0) != 0).isTrue();
            lastPriorityValue = removed.getPriority();
        }
        Assertions.assertThat(checkSet).isEmpty();
        Assertions.assertThat((Object)((TestElement)priorityQueue.poll())).isNull();
    }

    @Test
    void testIsEmpty() {
        HeapPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(1);
        Assertions.assertThat((boolean)priorityQueue.isEmpty()).isTrue();
        Assertions.assertThat((boolean)priorityQueue.add((HeapPriorityQueue.HeapPriorityQueueElement)new TestElement(4711L, 42L))).isTrue();
        Assertions.assertThat((boolean)priorityQueue.isEmpty()).isFalse();
        priorityQueue.poll();
        Assertions.assertThat((boolean)priorityQueue.isEmpty()).isTrue();
    }

    @Test
    void testAdd() {
        HeapPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(1);
        List<TestElement> testElements = Arrays.asList(new TestElement(4711L, 42L), new TestElement(815L, 23L));
        testElements.sort((l, r) -> this.getTestElementPriorityComparator().compare(r.priority, l.priority));
        Assertions.assertThat((boolean)priorityQueue.add((HeapPriorityQueue.HeapPriorityQueueElement)testElements.get(0))).isTrue();
        Assertions.assertThat((int)priorityQueue.size()).isEqualTo(1);
        Assertions.assertThat((boolean)priorityQueue.add((HeapPriorityQueue.HeapPriorityQueueElement)testElements.get(1))).isTrue();
        Assertions.assertThat((int)priorityQueue.size()).isEqualTo(2);
        Assertions.assertThat((Object)((TestElement)priorityQueue.poll())).isEqualTo((Object)testElements.get(1));
        Assertions.assertThat((int)priorityQueue.size()).isEqualTo(1);
        Assertions.assertThat((Object)((TestElement)priorityQueue.poll())).isEqualTo((Object)testElements.get(0));
        Assertions.assertThat((int)priorityQueue.size()).isZero();
    }

    @Test
    void testRemove() {
        HeapPriorityQueue<TestElement> priorityQueue = this.newPriorityQueue(1);
        long key = 4711L;
        long priorityValue = 42L;
        TestElement testElement = new TestElement(4711L, 42L);
        Assertions.assertThat((boolean)priorityQueue.add((HeapPriorityQueue.HeapPriorityQueueElement)testElement)).isTrue();
        Assertions.assertThat((boolean)priorityQueue.remove((HeapPriorityQueue.HeapPriorityQueueElement)testElement)).isTrue();
        Assertions.assertThat((boolean)priorityQueue.isEmpty()).isTrue();
    }

    @Test
    void testClear() {
        HeapPriorityQueue<TestElement> priorityQueueSet = this.newPriorityQueue(1);
        int count = 10;
        HashSet<TestElement> checkSet = new HashSet<TestElement>(count);
        HeapPriorityQueueTest.insertRandomElements(priorityQueueSet, checkSet, count);
        Assertions.assertThat((int)priorityQueueSet.size()).isEqualTo(count);
        priorityQueueSet.clear();
        Assertions.assertThat((int)priorityQueueSet.size()).isZero();
    }

    private HeapPriorityQueue<TestElement> newPriorityQueue(int initialCapacity) {
        return new HeapPriorityQueue(TEST_ELEMENT_PRIORITY_COMPARATOR, initialCapacity);
    }

    private Comparator<Long> getTestElementPriorityComparator() {
        return Long::compareTo;
    }

    private long getHighestPriorityValueForComparator() {
        return this.getTestElementPriorityComparator().compare(-1L, 1L) > 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
    }

    private static void insertRandomElements(HeapPriorityQueue<TestElement> priorityQueue, Set<TestElement> checkSet, int count) {
        ThreadLocalRandom localRandom = ThreadLocalRandom.current();
        int numUniqueKeys = Math.max(count / 4, 64);
        long duplicatePriority = Long.MIN_VALUE;
        boolean checkEndSizes = priorityQueue.isEmpty();
        for (int i = 0; i < count; ++i) {
            long elementPriority;
            TestElement element;
            do {
                if (duplicatePriority == Long.MIN_VALUE) {
                    elementPriority = localRandom.nextLong();
                    continue;
                }
                elementPriority = duplicatePriority;
                duplicatePriority = Long.MIN_VALUE;
            } while (!checkSet.add(element = new TestElement(localRandom.nextInt(numUniqueKeys), elementPriority)));
            if (localRandom.nextInt(10) == 0) {
                duplicatePriority = element.getPriority();
            }
            boolean headChangedIndicated = priorityQueue.add((HeapPriorityQueue.HeapPriorityQueueElement)element);
            if (!element.equals(priorityQueue.peek())) continue;
            Assertions.assertThat((boolean)headChangedIndicated).isTrue();
        }
        if (checkEndSizes) {
            Assertions.assertThat((int)count).isEqualTo(priorityQueue.size());
        }
    }

    private static class TestElement
    implements HeapPriorityQueue.HeapPriorityQueueElement {
        private final long key;
        private final long priority;
        private int internalIndex;

        public TestElement(long key, long priority) {
            this.key = key;
            this.priority = priority;
            this.internalIndex = Integer.MIN_VALUE;
        }

        public Long getKey() {
            return this.key;
        }

        public long getPriority() {
            return this.priority;
        }

        public int getInternalIndex() {
            return this.internalIndex;
        }

        public void setInternalIndex(int newIndex) {
            this.internalIndex = newIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestElement that = (TestElement)o;
            return this.key == that.key && this.priority == that.priority;
        }

        public int hashCode() {
            return Objects.hash(this.getKey(), this.getPriority());
        }

        public String toString() {
            return "TestElement{key=" + this.key + ", priority=" + this.priority + "}";
        }
    }
}

