/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.MockChannelStateWriter;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelBuilder;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateBuilder;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointableTask;
import org.apache.flink.runtime.mailbox.SyncMailboxExecutor;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.runtime.io.checkpointing.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.checkpointing.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.io.checkpointing.InputProcessorUtil;
import org.apache.flink.streaming.runtime.tasks.SubtaskCheckpointCoordinator;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TestSubtaskCheckpointCoordinator;
import org.apache.flink.streaming.runtime.tasks.TimerService;
import org.apache.flink.streaming.util.MockStreamTask;
import org.apache.flink.streaming.util.MockStreamTaskBuilder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class InputProcessorUtilTest {
    InputProcessorUtilTest() {
    }

    @Test
    void testCreateCheckpointedMultipleInputGate() throws Exception {
        try (CloseableRegistry registry = new CloseableRegistry();){
            CheckpointedInputGate[] checkpointedMultipleInputGate;
            MockEnvironment environment = new MockEnvironmentBuilder().build();
            MockStreamTask streamTask = new MockStreamTaskBuilder(environment).build();
            Configuration jobConf = streamTask.getJobConfiguration();
            jobConf.set(CheckpointingOptions.CHECKPOINTING_INTERVAL, (Object)Duration.ofSeconds(1L));
            jobConf.set(CheckpointingOptions.ENABLE_UNALIGNED, (Object)true);
            StreamConfig streamConfig = new StreamConfig(environment.getJobConfiguration());
            List[] inputGates = new List[]{Collections.singletonList(this.getGate(1, 4)), Collections.singletonList(this.getGate(0, 2))};
            CheckpointBarrierHandler barrierHandler = InputProcessorUtil.createCheckpointBarrierHandler((CheckpointableTask)streamTask, (Configuration)jobConf, (StreamConfig)streamConfig, (SubtaskCheckpointCoordinator)new TestSubtaskCheckpointCoordinator(new MockChannelStateWriter()), (String)streamTask.getName(), (List[])inputGates, Collections.emptyList(), (MailboxExecutor)new SyncMailboxExecutor(), (TimerService)new TestProcessingTimeService());
            for (CheckpointedInputGate checkpointedInputGate : checkpointedMultipleInputGate = InputProcessorUtil.createCheckpointedMultipleInputGate((MailboxExecutor)new SyncMailboxExecutor(), (List[])inputGates, (TaskIOMetricGroup)environment.getMetricGroup().getIOMetricGroup(), (CheckpointBarrierHandler)barrierHandler, (StreamConfig)streamConfig)) {
                registry.registerCloseable((AutoCloseable)checkpointedInputGate);
            }
            List allInputGates = Arrays.stream(inputGates).flatMap(gates -> gates.stream()).collect(Collectors.toList());
            for (IndexedInputGate inputGate : allInputGates) {
                for (int channelId = 0; channelId < inputGate.getNumberOfInputChannels(); ++channelId) {
                    barrierHandler.processBarrier(new CheckpointBarrier(1L, 42L, CheckpointOptions.unaligned((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)CheckpointStorageLocationReference.getDefault())), new InputChannelInfo(inputGate.getGateIndex(), channelId), false);
                }
            }
            Assertions.assertThat((CompletableFuture)barrierHandler.getAllBarriersReceivedFuture(1L)).isDone();
        }
    }

    private SingleInputGate getGate(int index, int numChannels) {
        return new SingleInputGateBuilder().setNumberOfChannels(numChannels).setSingleInputGateIndex(index).setChannelFactory(InputChannelBuilder::buildLocalChannel).build();
    }
}

