/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.time.Duration;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.runtime.operators.testutils.ExpectedTestException;
import org.apache.flink.streaming.runtime.io.checkpointing.BarrierAlignmentUtil;
import org.apache.flink.streaming.runtime.tasks.StreamTaskActionExecutor;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TimerService;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxExecutorImpl;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxProcessor;
import org.apache.flink.streaming.runtime.tasks.mailbox.TaskMailbox;
import org.apache.flink.streaming.runtime.tasks.mailbox.TaskMailboxImpl;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BarrierAlignmentUtilTest {
    BarrierAlignmentUtilTest() {
    }

    @Test
    void testDelayableTimerNotHiddenException() throws Exception {
        TaskMailboxImpl mailbox = new TaskMailboxImpl();
        MailboxProcessor mailboxProcessor = new MailboxProcessor(controller -> {}, (TaskMailbox)mailbox, StreamTaskActionExecutor.IMMEDIATE);
        MailboxExecutorImpl mailboxExecutor = new MailboxExecutorImpl((TaskMailbox)mailbox, 0, StreamTaskActionExecutor.IMMEDIATE, mailboxProcessor);
        TestProcessingTimeService timerService = new TestProcessingTimeService();
        timerService.setCurrentTime(System.currentTimeMillis());
        BarrierAlignmentUtil.DelayableTimer delayableTimer = BarrierAlignmentUtil.createRegisterTimerCallback((MailboxExecutor)mailboxExecutor, (TimerService)timerService);
        Duration delay = Duration.ofMinutes(10L);
        delayableTimer.registerTask(() -> {
            throw new ExpectedTestException();
        }, delay);
        timerService.advance(delay.toMillis());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MailboxProcessor)mailboxProcessor).runMailboxStep()).as("BarrierAlignmentUtil.DelayableTimer should not hide exceptions", new Object[0])).isInstanceOf(ExpectedTestException.class);
    }
}

