/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sortpartition;

import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.operators.sortpartition.KeyAndValueSerializer;
import org.apache.flink.streaming.api.operators.sortpartition.SerializerComparatorTestData;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class KeyAndValueSerializerTest
extends SerializerTestBase<Tuple2<byte[], Integer>> {
    private static final int DEFAULT_KEY_LENGTH = 4;
    private final IntSerializer valueSerializer = new IntSerializer();

    KeyAndValueSerializerTest() {
    }

    protected TypeSerializer<Tuple2<byte[], Integer>> createSerializer() {
        return new KeyAndValueSerializer((TypeSerializer)this.valueSerializer, 4);
    }

    protected int getLength() {
        return 4 + this.valueSerializer.getLength();
    }

    protected Class<Tuple2<byte[], Integer>> getTypeClass() {
        return Tuple2.class;
    }

    protected Tuple2<byte[], Integer>[] getTestData() {
        return SerializerComparatorTestData.getOrderedIntTestData();
    }

    @Test
    public void testConfigSnapshotInstantiation() {
        Assertions.assertThatThrownBy(() -> super.testConfigSnapshotInstantiation()).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testSnapshotConfigurationAndReconfigure() {
        Assertions.assertThatThrownBy(() -> super.testSnapshotConfigurationAndReconfigure()).isInstanceOf(UnsupportedOperationException.class);
    }
}

