/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.threadinfo;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.messages.ThreadInfoSample;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.webmonitor.threadinfo.VertexFlameGraph;
import org.apache.flink.runtime.webmonitor.threadinfo.VertexFlameGraphFactory;
import org.apache.flink.runtime.webmonitor.threadinfo.VertexThreadInfoStats;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Test;

class VertexFlameGraphFactoryTest {
    VertexFlameGraphFactoryTest() {
    }

    @Test
    void testLambdaClassNamesCleanUp() {
        Map<ExecutionAttemptID, Collection<ThreadInfoSample>> samplesBySubtask = this.generateSamples();
        VertexThreadInfoStats sample = new VertexThreadInfoStats(0, 0L, 0L, samplesBySubtask);
        VertexFlameGraph graph = VertexFlameGraphFactory.createFullFlameGraphFrom((VertexThreadInfoStats)sample);
        int encounteredLambdas = this.verifyRecursively(graph.getRoot());
        if (encounteredLambdas == 0) {
            Assertions.fail((String)"No lambdas encountered in the test, cleanup functionality was not tested");
        }
    }

    private int verifyRecursively(VertexFlameGraph.Node node) {
        String location = node.getStackTraceLocation();
        int lambdas = 0;
        final String javaVersion = System.getProperty("java.version");
        if (javaVersion.compareTo("21") < 0 && location.contains("$Lambda$") || javaVersion.compareTo("21") >= 0 && location.contains("$$Lambda")) {
            ++lambdas;
            String locationWithoutLineNumber = location.substring(0, location.lastIndexOf(":"));
            String className = locationWithoutLineNumber.substring(0, locationWithoutLineNumber.lastIndexOf("."));
            Assertions.assertThat((String)className).is((Condition)new Condition<String>(){

                public boolean matches(String value) {
                    return javaVersion.startsWith("1.8") && value.endsWith("$Lambda$0/0") || javaVersion.compareTo("21") < 0 && value.endsWith("$Lambda$0/0x0") || value.endsWith("$$Lambda0/0x0");
                }
            });
        }
        return lambdas + node.getChildren().stream().mapToInt(this::verifyRecursively).sum();
    }

    private Map<ExecutionAttemptID, Collection<ThreadInfoSample>> generateSamples() {
        ThreadInfoSample sample1 = (ThreadInfoSample)ThreadInfoSample.from((ThreadInfo)this.getStackTraceWithLambda()).get();
        ArrayList<ThreadInfoSample> samples = new ArrayList<ThreadInfoSample>();
        samples.add(sample1);
        ExecutionAttemptID executionAttemptID = new ExecutionAttemptID(new ExecutionGraphID(), new ExecutionVertexID(new JobVertexID(), 0), 0);
        HashMap<ExecutionAttemptID, Collection<ThreadInfoSample>> result = new HashMap<ExecutionAttemptID, Collection<ThreadInfoSample>>();
        result.put(executionAttemptID, samples);
        return result;
    }

    private ThreadInfo getStackTraceWithLambda() {
        Supplier<ThreadInfo> r1 = () -> ManagementFactory.getThreadMXBean().getThreadInfo(Thread.currentThread().getId(), Integer.MAX_VALUE);
        Supplier<ThreadInfo> r2 = () -> (ThreadInfo)r1.get();
        return r2.get();
    }
}

