/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.retriever;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.core.testutils.FlinkCompletableFutureAssert;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.TestingRpcGateway;
import org.apache.flink.runtime.webmonitor.retriever.LeaderGatewayRetriever;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class LeaderGatewayRetrieverTest {
    LeaderGatewayRetrieverTest() {
    }

    @Test
    void testGatewayRetrievalFailures() throws Exception {
        String address = "localhost";
        UUID leaderId = UUID.randomUUID();
        TestingRpcGateway rpcGateway = TestingRpcGateway.newBuilder().build();
        TestingLeaderGatewayRetriever leaderGatewayRetriever = new TestingLeaderGatewayRetriever(rpcGateway);
        SettableLeaderRetrievalService settableLeaderRetrievalService = new SettableLeaderRetrievalService();
        settableLeaderRetrievalService.start((LeaderRetrievalListener)leaderGatewayRetriever);
        CompletableFuture gatewayFuture = leaderGatewayRetriever.getFuture();
        settableLeaderRetrievalService.notifyListener("localhost", leaderId);
        ((FlinkCompletableFutureAssert)FlinkAssertions.assertThatFuture((CompletableFuture)gatewayFuture).as("The first future should have been failed.", new Object[0])).eventuallyFailsWith(ExecutionException.class);
        Assertions.assertThat((Optional)leaderGatewayRetriever.getNow()).isNotPresent();
        Assertions.assertThat((Optional)leaderGatewayRetriever.getNow()).hasValue((Object)rpcGateway);
    }

    private static class TestingLeaderGatewayRetriever
    extends LeaderGatewayRetriever<RpcGateway> {
        private final RpcGateway rpcGateway;
        private int retrievalAttempt = 0;

        private TestingLeaderGatewayRetriever(RpcGateway rpcGateway) {
            this.rpcGateway = rpcGateway;
        }

        protected CompletableFuture<RpcGateway> createGateway(CompletableFuture<Tuple2<String, UUID>> leaderFuture) {
            CompletableFuture result = this.retrievalAttempt < 2 ? FutureUtils.completedExceptionally((Throwable)new FlinkException("Could not resolve the leader gateway.")) : CompletableFuture.completedFuture(this.rpcGateway);
            ++this.retrievalAttempt;
            return result;
        }
    }
}

