/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.time.Instant;
import java.util.Arrays;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnvironmentInformationTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    EnvironmentInformationTest() {
    }

    @Test
    public void testJavaMemory() {
        try {
            long fullHeap = EnvironmentInformation.getMaxJvmHeapMemory();
            long freeWithGC = EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag();
            Assertions.assertThat((long)fullHeap).isGreaterThan(0L);
            Assertions.assertThat((long)freeWithGC).isGreaterThanOrEqualTo(0L);
            try {
                long free = EnvironmentInformation.getSizeOfFreeHeapMemory();
                Assertions.assertThat((long)free).isGreaterThanOrEqualTo(0L);
            }
            catch (RuntimeException e) {
                Assertions.assertThat((long)EnvironmentInformation.getMaxJvmHeapMemory()).isEqualTo(Long.MAX_VALUE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testEnvironmentMethods() {
        try {
            Assertions.assertThat((String)EnvironmentInformation.getJvmStartupOptions()).isNotNull();
            Assertions.assertThat((Object[])EnvironmentInformation.getJvmStartupOptionsArray()).isNotNull();
            Assertions.assertThat((String)EnvironmentInformation.getJvmVersion()).isNotNull();
            Assertions.assertThat((Object)EnvironmentInformation.getRevisionInformation()).isNotNull();
            Assertions.assertThat((String)EnvironmentInformation.getVersion()).isNotNull();
            Assertions.assertThat((String)EnvironmentInformation.getScalaVersion()).isNotNull();
            Assertions.assertThat((Instant)EnvironmentInformation.getBuildTime()).isNotNull();
            Assertions.assertThat((String)EnvironmentInformation.getBuildTimeString()).isNotNull();
            Assertions.assertThat((String)EnvironmentInformation.getGitCommitId()).isNotNull();
            Assertions.assertThat((String)EnvironmentInformation.getGitCommitIdAbbrev()).isNotNull();
            Assertions.assertThat((Instant)EnvironmentInformation.getGitCommitTime()).isNotNull();
            Assertions.assertThat((String)EnvironmentInformation.getGitCommitTimeString()).isNotNull();
            Assertions.assertThat((String)EnvironmentInformation.getHadoopVersionString()).isNotNull();
            Assertions.assertThat((String)EnvironmentInformation.getHadoopUser()).isNotNull();
            Assertions.assertThat((long)EnvironmentInformation.getOpenFileHandlesLimit()).isGreaterThanOrEqualTo(-1L);
            if (this.log.isInfoEnabled()) {
                this.log.info("JvmStartupOptions      : {}", (Object)EnvironmentInformation.getJvmStartupOptions());
                this.log.info("JvmStartupOptionsArray : {}", Arrays.asList(EnvironmentInformation.getJvmStartupOptionsArray()));
                this.log.info("JvmVersion             : {}", (Object)EnvironmentInformation.getJvmVersion());
                this.log.info("RevisionInformation    : {}", (Object)EnvironmentInformation.getRevisionInformation());
                this.log.info("Version                : {}", (Object)EnvironmentInformation.getVersion());
                this.log.info("ScalaVersion           : {}", (Object)EnvironmentInformation.getScalaVersion());
                this.log.info("BuildTime              : {}", (Object)EnvironmentInformation.getBuildTime());
                this.log.info("BuildTimeString        : {}", (Object)EnvironmentInformation.getBuildTimeString());
                this.log.info("GitCommitId            : {}", (Object)EnvironmentInformation.getGitCommitId());
                this.log.info("GitCommitIdAbbrev      : {}", (Object)EnvironmentInformation.getGitCommitIdAbbrev());
                this.log.info("GitCommitTime          : {}", (Object)EnvironmentInformation.getGitCommitTime());
                this.log.info("GitCommitTimeString    : {}", (Object)EnvironmentInformation.getGitCommitTimeString());
                this.log.info("HadoopVersionString    : {}", (Object)EnvironmentInformation.getHadoopVersionString());
                this.log.info("HadoopUser             : {}", (Object)EnvironmentInformation.getHadoopUser());
                this.log.info("OpenFileHandlesLimit   : {}", (Object)EnvironmentInformation.getOpenFileHandlesLimit());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testLogEnvironmentInformation() {
        try {
            Logger mockLogger = (Logger)Mockito.mock(Logger.class);
            EnvironmentInformation.logEnvironmentInfo((Logger)mockLogger, (String)"test", (String[])new String[0]);
            EnvironmentInformation.logEnvironmentInfo((Logger)mockLogger, (String)"test", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }
}

