/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.taskexecutor.slot.FileSlotAllocationSnapshotPersistenceService;
import org.apache.flink.runtime.taskexecutor.slot.SlotAllocationSnapshot;
import org.apache.flink.shaded.guava33.com.google.common.collect.Iterables;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FileSlotAllocationSnapshotPersistenceServiceTest {
    @TempDir
    private File tempDirectory;

    FileSlotAllocationSnapshotPersistenceServiceTest() {
    }

    @Test
    void loadNoSlotAllocationSnapshotsIfDirectoryIsEmpty() throws IOException {
        Assumptions.assumeTrue((boolean)FileUtils.isEmptyDirectory((File)this.tempDirectory));
        FileSlotAllocationSnapshotPersistenceService persistenceService = new FileSlotAllocationSnapshotPersistenceService(this.tempDirectory);
        Assertions.assertThat((Collection)persistenceService.loadAllocationSnapshots()).isEmpty();
    }

    @Test
    void loadPersistedSlotAllocationSnapshots() throws IOException {
        FileSlotAllocationSnapshotPersistenceService persistenceService = new FileSlotAllocationSnapshotPersistenceService(this.tempDirectory);
        Collection<SlotAllocationSnapshot> slotAllocationSnapshots = this.createRandomSlotAllocationSnapshots(3);
        for (SlotAllocationSnapshot slotAllocationSnapshot : slotAllocationSnapshots) {
            persistenceService.persistAllocationSnapshot(slotAllocationSnapshot);
        }
        Collection loadedSlotAllocationSnapshots = persistenceService.loadAllocationSnapshots();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)loadedSlotAllocationSnapshots).containsAll(slotAllocationSnapshots)).usingRecursiveComparison();
    }

    @Test
    void newInstanceLoadsPersistedSlotAllocationSnapshots() throws IOException {
        FileSlotAllocationSnapshotPersistenceService persistenceService = new FileSlotAllocationSnapshotPersistenceService(this.tempDirectory);
        Collection<SlotAllocationSnapshot> slotAllocationSnapshots = this.createRandomSlotAllocationSnapshots(3);
        for (SlotAllocationSnapshot slotAllocationSnapshot : slotAllocationSnapshots) {
            persistenceService.persistAllocationSnapshot(slotAllocationSnapshot);
        }
        FileSlotAllocationSnapshotPersistenceService newPersistenceService = new FileSlotAllocationSnapshotPersistenceService(this.tempDirectory);
        Collection loadedSlotAllocationSnapshots = newPersistenceService.loadAllocationSnapshots();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)loadedSlotAllocationSnapshots).containsAll(slotAllocationSnapshots)).usingRecursiveComparison();
    }

    @Test
    void deletePersistedSlotAllocationSnapshot() throws IOException {
        FileSlotAllocationSnapshotPersistenceService persistenceService = new FileSlotAllocationSnapshotPersistenceService(this.tempDirectory);
        SlotAllocationSnapshot singleSlotAllocationSnapshot = this.createSingleSlotAllocationSnapshot();
        persistenceService.persistAllocationSnapshot(singleSlotAllocationSnapshot);
        persistenceService.deleteAllocationSnapshot(singleSlotAllocationSnapshot.getSlotIndex());
        Assertions.assertThat((Collection)persistenceService.loadAllocationSnapshots()).isEmpty();
    }

    @Test
    void deleteCorruptedSlotAllocationSnapshots() throws IOException {
        FileSlotAllocationSnapshotPersistenceService persistenceService = new FileSlotAllocationSnapshotPersistenceService(this.tempDirectory);
        SlotAllocationSnapshot singleSlotAllocationSnapshot = this.createSingleSlotAllocationSnapshot();
        persistenceService.persistAllocationSnapshot(singleSlotAllocationSnapshot);
        Object[] files = this.tempDirectory.listFiles();
        Assertions.assertThat((Object[])files).hasSize(1);
        Object file = files[0];
        FileUtils.writeByteArrayToFile((File)file, (byte[])new byte[]{1, 2, 3, 4});
        Assertions.assertThat((Collection)persistenceService.loadAllocationSnapshots()).isEmpty();
        Assertions.assertThat((File)this.tempDirectory).isEmptyDirectory();
    }

    @Nonnull
    private Collection<SlotAllocationSnapshot> createRandomSlotAllocationSnapshots(int number) {
        ArrayList<SlotAllocationSnapshot> result = new ArrayList<SlotAllocationSnapshot>();
        ResourceID resourceId = ResourceID.generate();
        for (int slotIndex = 0; slotIndex < number; ++slotIndex) {
            result.add(new SlotAllocationSnapshot(new SlotID(resourceId, slotIndex), new JobID(), "foobar", new AllocationID(), ResourceProfile.UNKNOWN));
        }
        return result;
    }

    private SlotAllocationSnapshot createSingleSlotAllocationSnapshot() {
        return (SlotAllocationSnapshot)Iterables.getOnlyElement(this.createRandomSlotAllocationSnapshots(1));
    }
}

