/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.testutils.AllCallbackWrapper;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.runtime.blob.NoOpTaskExecutorBlobService;
import org.apache.flink.runtime.blob.TaskExecutorBlobService;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.WorkingDirectory;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.heartbeat.TestingHeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.runtime.metrics.util.TestingMetricRegistry;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcServiceExtension;
import org.apache.flink.runtime.security.token.DelegationTokenReceiverRepository;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.runtime.testutils.WorkingDirectoryExtension;
import org.apache.flink.shaded.guava33.com.google.common.collect.Sets;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

class TaskManagerRunnerStartupTest {
    private static final String LOCAL_HOST = "localhost";
    @RegisterExtension
    public static final AllCallbackWrapper<TestingRpcServiceExtension> RPC_SERVICE_EXTENSION_WRAPPER = new AllCallbackWrapper((CustomExtension)new TestingRpcServiceExtension());
    @TempDir
    public Path tempFolder;
    @TempDir
    public static File workingDirectoryFolder;
    @RegisterExtension
    private static final AllCallbackWrapper<WorkingDirectoryExtension> WORKING_DIRECTORY_EXTENSION_WRAPPER;
    private final RpcService rpcService = ((TestingRpcServiceExtension)RPC_SERVICE_EXTENSION_WRAPPER.getCustomExtension()).getTestingRpcService();
    private TestingHighAvailabilityServices highAvailabilityServices;

    TaskManagerRunnerStartupTest() {
    }

    @BeforeEach
    void setupTest() {
        this.highAvailabilityServices = new TestingHighAvailabilityServices();
        this.highAvailabilityServices.setResourceManagerLeaderRetriever(new SettableLeaderRetrievalService());
    }

    @AfterEach
    void tearDownTest() throws Exception {
        this.highAvailabilityServices.closeWithOptionalClean(true);
        this.highAvailabilityServices = null;
    }

    @Tag(value="org.apache.flink.testutils.junit.FailsInGHAContainerWithRootUser")
    @Test
    void testIODirectoryNotWritable() throws Exception {
        File nonWritable = TempDirUtils.newFolder((Path)this.tempFolder);
        Assumptions.assumeTrue((boolean)nonWritable.setWritable(false, false), (String)"Cannot create non-writable temporary file directory. Skipping test.");
        try {
            Configuration cfg = TaskManagerRunnerStartupTest.createFlinkConfiguration();
            cfg.set(CoreOptions.TMP_DIRS, (Object)nonWritable.getAbsolutePath());
            Assertions.assertThatThrownBy(() -> TaskManagerRunnerStartupTest.startTaskManager(cfg, this.rpcService, this.highAvailabilityServices, ((WorkingDirectoryExtension)WORKING_DIRECTORY_EXTENSION_WRAPPER.getCustomExtension()).createNewWorkingDirectory()), (String)"Should fail synchronously with an IOException", (Object[])new Object[0]).isInstanceOf(IOException.class);
        }
        finally {
            nonWritable.setWritable(true, false);
            try {
                FileUtils.deleteDirectory((File)nonWritable);
            }
            catch (IOException iOException) {}
        }
    }

    @Test
    void testMemoryConfigWrong() {
        Configuration cfg = TaskManagerRunnerStartupTest.createFlinkConfiguration();
        cfg.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)MemorySize.parse((String)"100m"));
        cfg.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)MemorySize.parse((String)"10m"));
        Assertions.assertThatThrownBy(() -> TaskManagerRunnerStartupTest.startTaskManager(cfg, this.rpcService, this.highAvailabilityServices, ((WorkingDirectoryExtension)WORKING_DIRECTORY_EXTENSION_WRAPPER.getCustomExtension()).createNewWorkingDirectory())).isInstanceOf(IllegalConfigurationException.class);
    }

    @Test
    void testStartupWhenNetworkStackFailsToInitialize() throws Exception {
        ServerSocket blocker = new ServerSocket(0, 50, InetAddress.getByName(LOCAL_HOST));
        try {
            Configuration cfg = TaskManagerRunnerStartupTest.createFlinkConfiguration();
            cfg.set(NettyShuffleEnvironmentOptions.DATA_PORT, (Object)blocker.getLocalPort());
            cfg.set(TaskManagerOptions.BIND_HOST, (Object)LOCAL_HOST);
            Assertions.assertThatThrownBy(() -> TaskManagerRunnerStartupTest.startTaskManager(cfg, this.rpcService, this.highAvailabilityServices, ((WorkingDirectoryExtension)WORKING_DIRECTORY_EXTENSION_WRAPPER.getCustomExtension()).createNewWorkingDirectory()), (String)"Should throw IOException when the network stack cannot be initialized.", (Object[])new Object[0]).isInstanceOf(IOException.class);
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)blocker);
        }
    }

    @Test
    void testMetricInitialization() throws Exception {
        Configuration cfg = TaskManagerRunnerStartupTest.createFlinkConfiguration();
        ArrayList registeredMetrics = new ArrayList();
        TaskManagerRunnerStartupTest.startTaskManager(cfg, this.rpcService, this.highAvailabilityServices, ((WorkingDirectoryExtension)WORKING_DIRECTORY_EXTENSION_WRAPPER.getCustomExtension()).createNewWorkingDirectory(), TestingMetricRegistry.builder().setRegisterConsumer((metric, metricName, group) -> registeredMetrics.add(group.getMetricIdentifier(metricName))).setScopeFormats(ScopeFormats.fromConfig((Configuration)cfg)).build());
        HashSet expectedTaskManagerMetricsWithoutTaskManagerId = Sets.newHashSet((Object[])new String[]{".taskmanager..Status.JVM.ClassLoader.ClassesLoaded", ".taskmanager..Status.JVM.ClassLoader.ClassesUnloaded", ".taskmanager..Status.JVM.Memory.Heap.Used", ".taskmanager..Status.JVM.Memory.Heap.Committed", ".taskmanager..Status.JVM.Memory.Heap.Max", ".taskmanager..Status.JVM.Memory.NonHeap.Used", ".taskmanager..Status.JVM.Memory.NonHeap.Committed", ".taskmanager..Status.JVM.Memory.NonHeap.Max", ".taskmanager..Status.JVM.Memory.Direct.Count", ".taskmanager..Status.JVM.Memory.Direct.MemoryUsed", ".taskmanager..Status.JVM.Memory.Direct.TotalCapacity", ".taskmanager..Status.JVM.Memory.Mapped.Count", ".taskmanager..Status.JVM.Memory.Mapped.MemoryUsed", ".taskmanager..Status.JVM.Memory.Mapped.TotalCapacity", ".taskmanager..Status.Flink.Memory.Managed.Used", ".taskmanager..Status.Flink.Memory.Managed.Total", ".taskmanager..Status.JVM.Threads.Count", ".taskmanager..Status.JVM.CPU.Load", ".taskmanager..Status.JVM.CPU.Time", ".taskmanager..Status.Shuffle.Netty.TotalMemorySegments", ".taskmanager..Status.Shuffle.Netty.TotalMemory", ".taskmanager..Status.Shuffle.Netty.AvailableMemorySegments", ".taskmanager..Status.Shuffle.Netty.AvailableMemory", ".taskmanager..Status.Shuffle.Netty.UsedMemorySegments", ".taskmanager..Status.Shuffle.Netty.UsedMemory"});
        Pattern pattern = Pattern.compile("\\.taskmanager\\.([^.]+)\\..*");
        Set registeredMetricsWithoutTaskManagerId = registeredMetrics.stream().map(pattern::matcher).flatMap(matcher -> matcher.find() ? Stream.of(matcher.group(0).replaceAll(matcher.group(1), "")) : Stream.empty()).collect(Collectors.toSet());
        Assertions.assertThat((Collection)expectedTaskManagerMetricsWithoutTaskManagerId).allSatisfy(ele -> Assertions.assertThat((String)ele).isIn((Iterable)registeredMetricsWithoutTaskManagerId));
    }

    private static Configuration createFlinkConfiguration() {
        return TaskExecutorResourceUtils.adjustForLocalExecution((Configuration)new Configuration());
    }

    private static void startTaskManager(Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, WorkingDirectory workingDirectory) throws Exception {
        TaskManagerRunnerStartupTest.startTaskManager(configuration, rpcService, highAvailabilityServices, workingDirectory, NoOpMetricRegistry.INSTANCE);
    }

    private static void startTaskManager(Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, WorkingDirectory workingDirectory, MetricRegistry metricRegistry) throws Exception {
        TaskManagerRunner.startTaskManager((Configuration)configuration, (ResourceID)ResourceID.generate(), (RpcService)rpcService, (HighAvailabilityServices)highAvailabilityServices, (HeartbeatServices)new TestingHeartbeatServices(), (MetricRegistry)metricRegistry, (TaskExecutorBlobService)NoOpTaskExecutorBlobService.INSTANCE, (boolean)false, (ExternalResourceInfoProvider)ExternalResourceInfoProvider.NO_EXTERNAL_RESOURCES, (WorkingDirectory)workingDirectory, error -> {}, (DelegationTokenReceiverRepository)new DelegationTokenReceiverRepository(configuration, null));
    }

    static {
        WORKING_DIRECTORY_EXTENSION_WRAPPER = new AllCallbackWrapper((CustomExtension)new WorkingDirectoryExtension(() -> workingDirectoryFolder));
    }
}

