/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.taskexecutor.TaskExecutorMemoryConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TaskExecutorMemoryConfigurationTest {
    TaskExecutorMemoryConfigurationTest() {
    }

    @Test
    void testInitialization() {
        Configuration config = new Configuration();
        config.set(TaskManagerOptions.FRAMEWORK_HEAP_MEMORY, (Object)new MemorySize(1L));
        config.set(TaskManagerOptions.TASK_HEAP_MEMORY, (Object)new MemorySize(2L));
        config.set(TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY, (Object)new MemorySize(3L));
        config.set(TaskManagerOptions.TASK_OFF_HEAP_MEMORY, (Object)new MemorySize(4L));
        config.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)new MemorySize(6L));
        config.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)new MemorySize(6L));
        config.set(TaskManagerOptions.NETWORK_MEMORY_FRACTION, (Object)Float.valueOf(0.1f));
        config.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)new MemorySize(7L));
        config.set(TaskManagerOptions.MANAGED_MEMORY_FRACTION, (Object)Float.valueOf(0.2f));
        config.set(TaskManagerOptions.JVM_METASPACE, (Object)new MemorySize(8L));
        config.set(TaskManagerOptions.JVM_OVERHEAD_MIN, (Object)new MemorySize(10L));
        config.set(TaskManagerOptions.JVM_OVERHEAD_MAX, (Object)new MemorySize(10L));
        config.set(TaskManagerOptions.JVM_OVERHEAD_FRACTION, (Object)Float.valueOf(0.3f));
        TaskExecutorMemoryConfiguration actual = TaskExecutorMemoryConfiguration.create((Configuration)config);
        TaskExecutorMemoryConfiguration expected = new TaskExecutorMemoryConfiguration(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(6L), Long.valueOf(7L), Long.valueOf(8L), Long.valueOf(10L), Long.valueOf(23L), Long.valueOf(41L));
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }
}

