/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.testutils;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.runtime.state.StateEntry;
import org.assertj.core.api.Assertions;

public final class StateAssertions {
    public static <K, N, S> void assertContainsExactly(Iterator<StateEntry<K, N, S>> stateEntries, Map<N, Map<K, S>> expected) {
        List expectedEntries = expected.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream().map(ksEntry -> new StateEntryWithEquals(entry.getKey(), ksEntry.getKey(), ksEntry.getValue()))).collect(Collectors.toList());
        Assertions.assertThat(stateEntries).toIterable().map(x$0 -> new StateEntryWithEquals(x$0)).containsExactlyInAnyOrderElementsOf(expectedEntries);
    }

    private StateAssertions() {
    }

    private static class StateEntryWithEquals<K, N, S>
    implements StateEntry<K, N, S> {
        private final N namespace;
        private final K key;
        private final S state;

        private StateEntryWithEquals(StateEntry<K, N, S> entry) {
            this(entry.getNamespace(), entry.getKey(), entry.getState());
        }

        private StateEntryWithEquals(N namespace, K key, S state) {
            this.namespace = namespace;
            this.key = key;
            this.state = state;
        }

        public K getKey() {
            return this.key;
        }

        public N getNamespace() {
            return this.namespace;
        }

        public S getState() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StateEntryWithEquals that = (StateEntryWithEquals)o;
            return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.key, that.key) && Objects.equals(this.state, that.state);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.key, this.state);
        }
    }
}

