/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.metrics.MetricsTrackingMapState;
import org.apache.flink.runtime.state.metrics.MetricsTrackingStateTestBase;
import org.apache.flink.util.function.SupplierWithException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MetricsTrackingMapStateTest
extends MetricsTrackingStateTestBase<Integer> {
    MetricsTrackingMapStateTest() {
    }

    @Override
    MapStateDescriptor<Integer, Double> getStateDescriptor() {
        return new MapStateDescriptor("map", Integer.class, Double.class);
    }

    @Override
    TypeSerializer<Integer> getKeySerializer() {
        return IntSerializer.INSTANCE;
    }

    @Override
    void setCurrentKey(AbstractKeyedStateBackend<Integer> keyedBackend) {
        keyedBackend.setCurrentKey((Object)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLatencyTrackingMapState() throws Exception {
        AbstractKeyedStateBackend<Integer> keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            MetricsTrackingMapState latencyTrackingState = (MetricsTrackingMapState)this.createMetricsTrackingState(keyedBackend, this.getStateDescriptor());
            latencyTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            MetricsTrackingMapState.MapStateMetrics latencyTrackingStateMetric = (MetricsTrackingMapState.MapStateMetrics)latencyTrackingState.getLatencyTrackingStateMetric();
            Assertions.assertThat((int)latencyTrackingStateMetric.getContainsCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getEntriesInitCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getGetCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getIsEmptyCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getIteratorInitCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getIteratorHasNextCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getIteratorNextCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getKeysInitCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getValuesInitCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getIteratorRemoveCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getPutAllCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getPutCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getRemoveCount()).isZero();
            this.setCurrentKey(keyedBackend);
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int index = 1; index <= 10; ++index) {
                int expectedResult = index == 10 ? 0 : index;
                latencyTrackingState.put((Object)random.nextLong(), (Object)random.nextDouble());
                Assertions.assertThat((int)latencyTrackingStateMetric.getPutCount()).isEqualTo(expectedResult);
                latencyTrackingState.putAll(Collections.singletonMap(random.nextLong(), random.nextDouble()));
                Assertions.assertThat((int)latencyTrackingStateMetric.getPutAllCount()).isEqualTo(expectedResult);
                latencyTrackingState.get((Object)random.nextLong());
                Assertions.assertThat((int)latencyTrackingStateMetric.getGetCount()).isEqualTo(expectedResult);
                latencyTrackingState.remove((Object)random.nextLong());
                Assertions.assertThat((int)latencyTrackingStateMetric.getRemoveCount()).isEqualTo(expectedResult);
                latencyTrackingState.contains((Object)random.nextLong());
                Assertions.assertThat((int)latencyTrackingStateMetric.getContainsCount()).isEqualTo(expectedResult);
                latencyTrackingState.isEmpty();
                Assertions.assertThat((int)latencyTrackingStateMetric.getIsEmptyCount()).isEqualTo(expectedResult);
                latencyTrackingState.entries();
                Assertions.assertThat((int)latencyTrackingStateMetric.getEntriesInitCount()).isEqualTo(expectedResult);
                latencyTrackingState.keys();
                Assertions.assertThat((int)latencyTrackingStateMetric.getKeysInitCount()).isEqualTo(expectedResult);
                latencyTrackingState.values();
                Assertions.assertThat((int)latencyTrackingStateMetric.getValuesInitCount()).isEqualTo(expectedResult);
                latencyTrackingState.iterator();
                Assertions.assertThat((int)latencyTrackingStateMetric.getIteratorInitCount()).isEqualTo(expectedResult);
            }
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSizeTrackingMapState() throws Exception {
        AbstractKeyedStateBackend<Integer> keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            MetricsTrackingMapState sizeTrackingState = (MetricsTrackingMapState)this.createMetricsTrackingState(keyedBackend, this.getStateDescriptor());
            sizeTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            MetricsTrackingMapState.MapStateMetrics sizeTrackingStateMetric = (MetricsTrackingMapState.MapStateMetrics)sizeTrackingState.getSizeTrackingStateMetric();
            Assertions.assertThat((int)sizeTrackingStateMetric.getContainsCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getEntriesInitCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getGetCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getIsEmptyCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getIteratorInitCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getIteratorHasNextCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getIteratorNextCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getKeysInitCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getValuesInitCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getIteratorRemoveCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getPutAllCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getPutCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getRemoveCount()).isZero();
            this.setCurrentKey(keyedBackend);
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int index = 1; index <= 10; ++index) {
                int expectedResult = index == 10 ? 0 : index;
                sizeTrackingState.put((Object)random.nextLong(), (Object)random.nextDouble());
                Assertions.assertThat((int)sizeTrackingStateMetric.getPutCount()).isEqualTo(expectedResult);
                sizeTrackingState.putAll(Collections.singletonMap(random.nextLong(), random.nextDouble()));
                Assertions.assertThat((int)sizeTrackingStateMetric.getPutAllCount()).isEqualTo(expectedResult);
                sizeTrackingState.get((Object)random.nextLong());
                Assertions.assertThat((int)sizeTrackingStateMetric.getGetCount()).isEqualTo(expectedResult);
                sizeTrackingState.contains((Object)random.nextLong());
                Assertions.assertThat((int)sizeTrackingStateMetric.getContainsCount()).isEqualTo(expectedResult);
                sizeTrackingState.remove((Object)random.nextLong());
                Assertions.assertThat((int)sizeTrackingStateMetric.getRemoveCount()).isEqualTo(expectedResult);
                sizeTrackingState.isEmpty();
                Assertions.assertThat((int)sizeTrackingStateMetric.getIsEmptyCount()).isEqualTo(expectedResult);
            }
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLatencyTrackingMapStateIterator() throws Exception {
        AbstractKeyedStateBackend<Integer> keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            MetricsTrackingMapState latencyTrackingState = (MetricsTrackingMapState)this.createMetricsTrackingState(keyedBackend, this.getStateDescriptor());
            latencyTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            MetricsTrackingMapState.MapStateMetrics latencyTrackingStateMetric = (MetricsTrackingMapState.MapStateMetrics)latencyTrackingState.getLatencyTrackingStateMetric();
            this.setCurrentKey(keyedBackend);
            this.verifyLatencyTrackingIterator((MetricsTrackingMapState<Integer, VoidNamespace, Long, Double>)latencyTrackingState, latencyTrackingStateMetric, () -> ((MetricsTrackingMapState)latencyTrackingState).iterator(), true);
            this.verifyLatencyTrackingIterator((MetricsTrackingMapState<Integer, VoidNamespace, Long, Double>)latencyTrackingState, latencyTrackingStateMetric, () -> latencyTrackingState.entries().iterator(), true);
            this.verifyLatencyTrackingIterator((MetricsTrackingMapState<Integer, VoidNamespace, Long, Double>)latencyTrackingState, latencyTrackingStateMetric, () -> latencyTrackingState.keys().iterator(), false);
            this.verifyLatencyTrackingIterator((MetricsTrackingMapState<Integer, VoidNamespace, Long, Double>)latencyTrackingState, latencyTrackingStateMetric, () -> latencyTrackingState.values().iterator(), false);
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSizeTrackingMapStateIterator() throws Exception {
        AbstractKeyedStateBackend<Integer> keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            MetricsTrackingMapState sizeTrackingState = (MetricsTrackingMapState)this.createMetricsTrackingState(keyedBackend, this.getStateDescriptor());
            sizeTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            MetricsTrackingMapState.MapStateMetrics sizeTrackingStateMetric = (MetricsTrackingMapState.MapStateMetrics)sizeTrackingState.getSizeTrackingStateMetric();
            this.setCurrentKey(keyedBackend);
            this.verifySizeTrackingIterator((MetricsTrackingMapState<Integer, VoidNamespace, Long, Double>)sizeTrackingState, sizeTrackingStateMetric, () -> ((MetricsTrackingMapState)sizeTrackingState).iterator(), true);
            this.verifySizeTrackingIterator((MetricsTrackingMapState<Integer, VoidNamespace, Long, Double>)sizeTrackingState, sizeTrackingStateMetric, () -> sizeTrackingState.entries().iterator(), true);
            this.verifySizeTrackingIterator((MetricsTrackingMapState<Integer, VoidNamespace, Long, Double>)sizeTrackingState, sizeTrackingStateMetric, () -> sizeTrackingState.keys().iterator(), false);
            this.verifySizeTrackingIterator((MetricsTrackingMapState<Integer, VoidNamespace, Long, Double>)sizeTrackingState, sizeTrackingStateMetric, () -> sizeTrackingState.values().iterator(), false);
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }

    private <E> void verifyLatencyTrackingIterator(MetricsTrackingMapState<Integer, VoidNamespace, Long, Double> latencyTrackingState, MetricsTrackingMapState.MapStateMetrics latencyTrackingStateMetric, SupplierWithException<Iterator<E>, Exception> iteratorSupplier, boolean removeIterator) throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int index = 1; index <= 10; ++index) {
            latencyTrackingState.put((Object)index, (Object)random.nextDouble());
        }
        int count = 1;
        Iterator iterator = (Iterator)iteratorSupplier.get();
        while (iterator.hasNext()) {
            int expectedResult = count == 10 ? 0 : count;
            Assertions.assertThat((int)latencyTrackingStateMetric.getIteratorHasNextCount()).isEqualTo(expectedResult);
            iterator.next();
            Assertions.assertThat((int)latencyTrackingStateMetric.getIteratorNextCount()).isEqualTo(expectedResult);
            if (removeIterator) {
                iterator.remove();
                Assertions.assertThat((int)latencyTrackingStateMetric.getIteratorRemoveCount()).isEqualTo(expectedResult);
            }
            ++count;
        }
        latencyTrackingStateMetric.resetIteratorHasNextCount();
        latencyTrackingState.clear();
    }

    private <E> void verifySizeTrackingIterator(MetricsTrackingMapState<Integer, VoidNamespace, Long, Double> sizeTrackingState, MetricsTrackingMapState.MapStateMetrics sizeTrackingStateMetric, SupplierWithException<Iterator<E>, Exception> iteratorSupplier, boolean removeIterator) throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int index = 1; index <= 10; ++index) {
            sizeTrackingState.put((Object)index, (Object)random.nextDouble());
        }
        int count = 1;
        Iterator iterator = (Iterator)iteratorSupplier.get();
        while (iterator.hasNext()) {
            int expectedResult = count == 10 ? 0 : count;
            iterator.next();
            Assertions.assertThat((int)sizeTrackingStateMetric.getIteratorNextCount()).isEqualTo(expectedResult);
            if (removeIterator) {
                iterator.remove();
            }
            ++count;
        }
        sizeTrackingStateMetric.resetIteratorHasNextCount();
        sizeTrackingState.clear();
    }
}

