/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.metrics.MetricsTrackingAggregatingState;
import org.apache.flink.runtime.state.metrics.MetricsTrackingStateTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MetricsTrackingAggregatingStateTest
extends MetricsTrackingStateTestBase<Integer> {
    MetricsTrackingAggregatingStateTest() {
    }

    AggregatingStateDescriptor<Long, Long, Long> getStateDescriptor() {
        return new AggregatingStateDescriptor("aggregate", (AggregateFunction)new AggregateFunction<Long, Long, Long>(){
            private static final long serialVersionUID = 1L;

            public Long createAccumulator() {
                return 0L;
            }

            public Long add(Long value, Long accumulator) {
                return value + accumulator;
            }

            public Long getResult(Long accumulator) {
                return accumulator;
            }

            public Long merge(Long a, Long b) {
                return a + b;
            }
        }, Long.class);
    }

    @Override
    TypeSerializer<Integer> getKeySerializer() {
        return IntSerializer.INSTANCE;
    }

    @Override
    void setCurrentKey(AbstractKeyedStateBackend<Integer> keyedBackend) {
        keyedBackend.setCurrentKey((Object)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLatencyTrackingAggregatingState() throws Exception {
        AbstractKeyedStateBackend<Integer> keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            MetricsTrackingAggregatingState latencyTrackingState = (MetricsTrackingAggregatingState)this.createMetricsTrackingState(keyedBackend, this.getStateDescriptor());
            latencyTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            MetricsTrackingAggregatingState.AggregatingStateMetrics latencyTrackingStateMetric = (MetricsTrackingAggregatingState.AggregatingStateMetrics)latencyTrackingState.getLatencyTrackingStateMetric();
            Assertions.assertThat((int)latencyTrackingStateMetric.getAddCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getGetCount()).isZero();
            Assertions.assertThat((int)latencyTrackingStateMetric.getMergeNamespaceCount()).isZero();
            this.setCurrentKey(keyedBackend);
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int index = 1; index <= 10; ++index) {
                int expectedResult = index == 10 ? 0 : index;
                latencyTrackingState.add((Object)random.nextLong());
                Assertions.assertThat((int)latencyTrackingStateMetric.getAddCount()).isEqualTo(expectedResult);
                latencyTrackingState.get();
                Assertions.assertThat((int)latencyTrackingStateMetric.getGetCount()).isEqualTo(expectedResult);
                latencyTrackingState.mergeNamespaces((Object)VoidNamespace.INSTANCE, Collections.emptyList());
                Assertions.assertThat((int)latencyTrackingStateMetric.getMergeNamespaceCount()).isEqualTo(expectedResult);
            }
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSizeTrackingAggregatingState() throws Exception {
        AbstractKeyedStateBackend<Integer> keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            MetricsTrackingAggregatingState sizeTrackingState = (MetricsTrackingAggregatingState)this.createMetricsTrackingState(keyedBackend, this.getStateDescriptor());
            sizeTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            MetricsTrackingAggregatingState.AggregatingStateMetrics sizeTrackingStateMetric = (MetricsTrackingAggregatingState.AggregatingStateMetrics)sizeTrackingState.getSizeTrackingStateMetric();
            Assertions.assertThat((int)sizeTrackingStateMetric.getAddCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getGetCount()).isZero();
            Assertions.assertThat((int)sizeTrackingStateMetric.getMergeNamespaceCount()).isZero();
            this.setCurrentKey(keyedBackend);
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int index = 1; index <= 10; ++index) {
                int expectedResult = index == 10 ? 0 : index;
                sizeTrackingState.add((Object)random.nextLong());
                Assertions.assertThat((int)sizeTrackingStateMetric.getAddCount()).isEqualTo(expectedResult);
                sizeTrackingState.get();
                Assertions.assertThat((int)sizeTrackingStateMetric.getGetCount()).isEqualTo(expectedResult);
            }
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }
}

