/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.AbstractFileCheckpointStorageAccessTestBase;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;
import org.apache.flink.runtime.state.memory.MemoryBackendCheckpointStorageAccess;
import org.apache.flink.runtime.state.storage.JobManagerCheckpointStorage;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class MemoryCheckpointStorageAccessTest
extends AbstractFileCheckpointStorageAccessTestBase {
    private static final int DEFAULT_MAX_STATE_SIZE = 0x500000;

    @Override
    protected CheckpointStorageAccess createCheckpointStorage(Path checkpointDir, boolean createCheckpointSubDir) throws Exception {
        return new MemoryBackendCheckpointStorageAccess(new JobID(), checkpointDir, null, createCheckpointSubDir, 0x500000);
    }

    @Override
    protected CheckpointStorageAccess createCheckpointStorageWithSavepointDir(Path checkpointDir, Path savepointDir, boolean createCheckpointSubDir) throws Exception {
        return new MemoryBackendCheckpointStorageAccess(new JobID(), checkpointDir, savepointDir, createCheckpointSubDir, 0x500000);
    }

    @Test
    void testParametrizationDefault() throws Exception {
        JobID jid = new JobID();
        JobManagerCheckpointStorage jobManagerCheckpointStorage = new JobManagerCheckpointStorage();
        MemoryBackendCheckpointStorageAccess storage = (MemoryBackendCheckpointStorageAccess)jobManagerCheckpointStorage.createCheckpointStorage(jid);
        Assertions.assertThat((boolean)storage.supportsHighlyAvailableStorage()).isFalse();
        Assertions.assertThat((boolean)storage.hasDefaultSavepointLocation()).isFalse();
        Assertions.assertThat((Object)storage.getDefaultSavepointDirectory()).isNull();
        Assertions.assertThat((int)storage.getMaxStateSize()).isEqualTo(0x500000);
    }

    @Test
    void testParametrizationDirectories() throws Exception {
        JobID jid = new JobID();
        String checkpointPath = TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI().toString();
        JobManagerCheckpointStorage jobManagerCheckpointStorage = new JobManagerCheckpointStorage(checkpointPath);
        MemoryBackendCheckpointStorageAccess storage = (MemoryBackendCheckpointStorageAccess)jobManagerCheckpointStorage.createCheckpointStorage(jid);
        Assertions.assertThat((boolean)storage.supportsHighlyAvailableStorage()).isTrue();
    }

    @Test
    void testParametrizationStateSize() throws Exception {
        int maxSize = 17;
        JobManagerCheckpointStorage jobManagerCheckpointStorage = new JobManagerCheckpointStorage(17);
        MemoryBackendCheckpointStorageAccess storage = (MemoryBackendCheckpointStorageAccess)jobManagerCheckpointStorage.createCheckpointStorage(new JobID());
        Assertions.assertThat((int)storage.getMaxStateSize()).isEqualTo(17);
    }

    @Test
    void testNonPersistentCheckpointLocation() throws Exception {
        MemoryBackendCheckpointStorageAccess storage = new MemoryBackendCheckpointStorageAccess(new JobID(), null, null, true, 0x500000);
        CheckpointStorageLocation location = storage.initializeLocationForCheckpoint(9L);
        CheckpointMetadataOutputStream stream = location.createMetadataOutputStream();
        stream.write(99);
        CompletedCheckpointStorageLocation completed = stream.closeAndFinalizeCheckpoint();
        StreamStateHandle handle = completed.getMetadataHandle();
        Assertions.assertThat((Object)handle).isInstanceOf(ByteStreamStateHandle.class);
        Assertions.assertThatThrownBy(() -> storage.resolveCheckpoint(completed.getExternalPointer())).isInstanceOf(FileNotFoundException.class);
    }

    @Test
    void testLocationReference() throws Exception {
        MemoryBackendCheckpointStorageAccess storage = new MemoryBackendCheckpointStorageAccess(new JobID(), null, null, true, 0x500000);
        CheckpointStorageLocation location = storage.initializeLocationForCheckpoint(42L);
        Assertions.assertThat((boolean)location.getLocationReference().isDefaultReference()).isTrue();
        storage = new MemoryBackendCheckpointStorageAccess(new JobID(), this.randomTempPath(), null, true, 0x500000);
        location = storage.initializeLocationForCheckpoint(42L);
        Assertions.assertThat((boolean)location.getLocationReference().isDefaultReference()).isTrue();
        storage = new MemoryBackendCheckpointStorageAccess(new JobID(), null, null, true, 0x500000);
        location = storage.initializeLocationForSavepoint(1337L, this.randomTempPath().toString());
        Assertions.assertThat((boolean)location.getLocationReference().isDefaultReference()).isTrue();
    }

    @Test
    void testTaskOwnedStateStream() throws Exception {
        StreamStateHandle stateHandle;
        List<String> state = Arrays.asList("Flopsy", "Mopsy", "Cotton Tail", "Peter");
        MemoryBackendCheckpointStorageAccess storage = new MemoryBackendCheckpointStorageAccess(new JobID(), null, null, true, 0x500000);
        try (CheckpointStateOutputStream stream = storage.createTaskOwnedStateStream();){
            Assertions.assertThat((Object)stream).isInstanceOf(MemCheckpointStreamFactory.MemoryCheckpointOutputStream.class);
            new ObjectOutputStream((OutputStream)stream).writeObject(state);
            stateHandle = stream.closeAndGetHandle();
        }
        try (ObjectInputStream in = new ObjectInputStream((InputStream)stateHandle.openInputStream());){
            Assertions.assertThat((Object)in.readObject()).isEqualTo(state);
        }
    }

    @Test
    void testStorageLocationMkdirs() throws Exception {
        MemoryBackendCheckpointStorageAccess storage = new MemoryBackendCheckpointStorageAccess(new JobID(), new Path(this.randomTempPath(), "chk"), null, true, 0x500000);
        File baseDir = new File(storage.getCheckpointsDirectory().getPath());
        Assertions.assertThat((File)baseDir).doesNotExist();
        storage.initializeLocationForCheckpoint(177L);
        Assertions.assertThat((File)baseDir).exists();
    }
}

